/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.mockserver.url;

import software.xdev.mockserver.util.StringUtils;

public final class URLParser {
    private static final String SCHEME_REGEX = "https?://.*";
    private static final String SCHEME_HOST_AND_PORT_REGEX = "https?://([A-z0-9-_.:]*@)?[A-z0-9-_.]*(:[0-9]*)?";

    public static boolean isFullUrl(String uri) {
        return uri != null && uri.matches(SCHEME_REGEX);
    }

    public static String returnPath(String path) {
        String result = URLParser.isFullUrl(path) ? path.replaceAll(SCHEME_HOST_AND_PORT_REGEX, "") : path;
        return StringUtils.substringBefore(result, "?");
    }

    private URLParser() {
    }
}

