/*
 * Copyright © 2024 XDEV Software (https://xdev.software)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package software.xdev.mockserver.util;

/**
 * Emulation of Apache Commons Lang3 StringUtils. Can nowadays be done using native Java.
 * <p/>
 * <b>DO NOT USE</b>
 */
public final class StringUtils
{
	public static String removeStart(final String str, final String remove)
	{
		if(isEmpty(str) || isEmpty(remove))
		{
			return str;
		}
		if(str.startsWith(remove))
		{
			return str.substring(remove.length());
		}
		return str;
	}
	
	public static String defaultIfEmpty(final String str, final String defaultStr)
	{
		return isEmpty(str) ? defaultStr : str;
	}
	
	public static String substringBefore(final String str, final String separator)
	{
		if(isEmpty(str) || separator == null)
		{
			return str;
		}
		if(separator.isEmpty())
		{
			return "";
		}
		final int pos = str.indexOf(separator);
		if(pos == -1)
		{
			return str;
		}
		return str.substring(0, pos);
	}
	
	public static String substringAfter(final String str, final String separator)
	{
		if(isEmpty(str))
		{
			return str;
		}
		if(separator == null)
		{
			return "";
		}
		final int pos = str.indexOf(separator);
		if(pos == -1)
		{
			return "";
		}
		return str.substring(pos + separator.length());
	}
	
	public static boolean isEmpty(final String s)
	{
		return s == null || s.isEmpty();
	}
	
	public static boolean isBlank(final String s)
	{
		return s == null || s.isBlank();
	}
	
	public static boolean isNotBlank(final String s)
	{
		return !isBlank(s);
	}
	
	private StringUtils()
	{
	}
}
