package software.rsquared.restapi;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Pair;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Rafał Zajfert
 */
public class Parameters {

	final List<Pair<String, Object>> parameters = new ArrayList<>();
	final List<Pair<String, Object>> queryParameters = new ArrayList<>();
	final List<Pair<String, String>> headers = new ArrayList<>();

	/**
	 * Adds parameter to request body
	 */
	public final void putParameter(@NonNull String name, @Nullable Object value) {
		parameters.add(new Pair<>(name, value));
	}

	/**
	 * Adds parameter to request body
	 */
	public final void putParameter(@Nullable Object value) {
		parameters.add(new Pair<>(null, value));
	}

	public final void addHeader(@NonNull String name, @NonNull String value) {
		headers.add(new Pair<>(name, value));
	}

	/**
	 * Adds parameter to URL's query string.
	 */
	public final void putQueryParameter(@NonNull String name, @Nullable Object value) {
		queryParameters.add(new Pair<>(name, value));
	}

	/**
	 * Adds parameter to URL's query string.
	 */
	public final void putQueryParameter(@Nullable Object value) {
		queryParameters.add(new Pair<>(null, value));
	}
}
