/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import java.util.LinkedHashMap;
import java.util.Map;
import software.rsquared.restapi.PoolRequest;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.RestApi;
import software.rsquared.restapi.exceptions.RequestException;

class ThreadPoolRequest
extends PoolRequest<ThreadPoolRequest> {
    private Map<Integer, Object> results = new LinkedHashMap<Integer, Object>();

    public ThreadPoolRequest(int poolSize) {
        super(poolSize);
    }

    @Override
    public void execute() {
        if (this.executed) {
            throw new IllegalStateException("Already executed.");
        }
        this.executed = true;
        this.onPreExecute();
        for (Map.Entry entry : this.requestPool.entrySet()) {
            this.executor.submit(((Request)entry.getValue()).createRequestTask(), ((Request)entry.getValue()).isErrorCallbackIgnored() ? null : RestApi.getConfiguration().getErrorCallback(), new PoolRequest.PoolRequestListener((int)((Integer)entry.getKey())){

                @Override
                public void onSuccess(Object result) {
                    int requestCode = this.getRequestCode();
                    ThreadPoolRequest.this.onTaskSuccess(result, requestCode);
                    ThreadPoolRequest.this.results.put(requestCode, result);
                    this.checkFinished(false);
                }

                @Override
                public void onFailed(RequestException e) {
                    int requestCode = this.getRequestCode();
                    ThreadPoolRequest.this.onFailed(e, requestCode);
                    if (ThreadPoolRequest.this.canContinueAfterFailed(e, requestCode)) {
                        ThreadPoolRequest.this.results.put(requestCode, null);
                        this.checkFinished(false);
                    } else {
                        this.checkFinished(true);
                    }
                }

                @Override
                public void onCanceled() {
                    ThreadPoolRequest.this.cancelled = true;
                }

                private void checkFinished(boolean forceFinish) {
                    if (ThreadPoolRequest.this.cancelled) {
                        ThreadPoolRequest.this.stopExecute();
                        ThreadPoolRequest.this.onCanceled();
                    } else {
                        boolean allFinished;
                        boolean bl = allFinished = ThreadPoolRequest.this.results.size() == ThreadPoolRequest.this.requestPool.size();
                        if (allFinished || forceFinish) {
                            ThreadPoolRequest.this.stopExecute();
                            if (allFinished) {
                                ThreadPoolRequest.this.onSuccess(ThreadPoolRequest.this.results);
                            }
                            ThreadPoolRequest.this.onPostExecute();
                        }
                    }
                }
            });
        }
        this.executor.shutdown();
    }
}

