/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import software.rsquared.restapi.PoolRequest;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.RestApi;
import software.rsquared.restapi.exceptions.RequestException;

class SerialPoolRequest
extends PoolRequest<SerialPoolRequest> {
    private Map<Integer, Object> results = new LinkedHashMap<Integer, Object>();
    private Iterator<Map.Entry<Integer, Request>> executeIterator;

    public SerialPoolRequest() {
        super(1);
    }

    @Override
    public void execute() {
        if (this.executed) {
            throw new IllegalStateException("Already executed.");
        }
        this.executed = true;
        this.executeIterator = this.requestPool.entrySet().iterator();
        this.onPreExecute();
        this.executeNext();
    }

    private void executeNext() {
        if (!this.cancelled && this.executeIterator.hasNext()) {
            Map.Entry<Integer, Request> requestEntry = this.executeIterator.next();
            this.executor.submit(requestEntry.getValue().createRequestTask(), requestEntry.getValue().isErrorCallbackIgnored() ? null : RestApi.getConfiguration().getErrorCallback(), new PoolRequest.PoolRequestListener((int)requestEntry.getKey()){

                @Override
                public void onSuccess(Object result) {
                    int requestCode = this.getRequestCode();
                    SerialPoolRequest.this.onTaskSuccess(result, requestCode);
                    SerialPoolRequest.this.results.put(requestCode, result);
                    SerialPoolRequest.this.executeNext();
                }

                @Override
                public void onFailed(RequestException e) {
                    int requestCode = this.getRequestCode();
                    SerialPoolRequest.this.onFailed(e, requestCode);
                    if (SerialPoolRequest.this.canContinueAfterFailed(e, requestCode)) {
                        SerialPoolRequest.this.results.put(requestCode, null);
                        SerialPoolRequest.this.executeNext();
                    }
                }

                @Override
                public void onCanceled() {
                    int requestCode = this.getRequestCode();
                    SerialPoolRequest.this.cancelled = true;
                    SerialPoolRequest.this.results.put(requestCode, null);
                    SerialPoolRequest.this.executeNext();
                }
            });
        } else {
            this.stopExecute();
            if (this.cancelled) {
                this.onCanceled();
            } else if (this.results.size() == this.requestPool.size()) {
                this.onSuccess(this.results);
            }
            this.onPostExecute();
        }
    }
}

