/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.SparseArray;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import software.rsquared.androidlogger.Level;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.logcat.LogcatLogger;
import software.rsquared.androidlogger.logcat.LogcatLoggerConfig;
import software.rsquared.restapi.BasicAuthorization;
import software.rsquared.restapi.InitialRequirements;
import software.rsquared.restapi.PoolRequest;
import software.rsquared.restapi.Request;
import software.rsquared.restapi.RequestFuture;
import software.rsquared.restapi.RestAuthorizationService;
import software.rsquared.restapi.SerialPoolRequest;
import software.rsquared.restapi.ThreadPoolRequest;
import software.rsquared.restapi.exceptions.DefaultErrorResponse;
import software.rsquared.restapi.exceptions.RequestException;
import software.rsquared.restapi.listeners.ErrorCallback;
import software.rsquared.restapi.listeners.RequestListener;
import software.rsquared.restapi.listeners.RequestPoolListener;
import software.rsquared.restapi.serialization.Deserializer;
import software.rsquared.restapi.serialization.ErrorDeserializer;
import software.rsquared.restapi.serialization.JsonDeserializer;
import software.rsquared.restapi.serialization.JsonErrorDeserializer;
import software.rsquared.restapi.serialization.ObjectToFormSerializer;
import software.rsquared.restapi.serialization.Serializer;

public class RestApi {
    public static final int THREAD_POOL_EXECUTOR = 1;
    public static final int SERIAL_EXECUTOR = 2;
    private static Config configuration;
    private static SparseArray<RequestFuture> requests;
    private static SparseArray<PoolRequest> poolRequests;

    static Config getConfiguration() {
        return configuration;
    }

    public static void setConfiguration(Config configuration) {
        RestApi.configuration = configuration;
    }

    static Logger getLogger() {
        return configuration.logger;
    }

    static boolean isConfigured() {
        return configuration != null;
    }

    public static <E> void execute(Request<E> request, RequestListener<E> listener) {
        request.execute(listener);
    }

    public static <E> E executeSync(Request<E> request) throws RequestException {
        return request.execute().get();
    }

    public static <E> void execute(Request<E> request, final int requestCode, final RequestListener<E> listener) {
        RequestFuture<E> future = request.execute(new RequestListener<E>(){

            @Override
            public void onSuccess(E result) {
                listener.onSuccess(result);
            }

            @Override
            public void onFailed(RequestException e) {
                listener.onFailed(e);
            }

            @Override
            public void onPreExecute() {
                listener.onPreExecute();
            }

            @Override
            public void onPostExecute() {
                requests.delete(requestCode);
                listener.onPostExecute();
            }

            @Override
            public void onCancel() {
                listener.onCancel();
            }
        });
        requests.put(requestCode, future);
    }

    public static PoolBuilder pool(int executor) {
        return new PoolBuilder(executor);
    }

    public static void cancel(int requestCode) {
        RequestFuture future = (RequestFuture)requests.get(requestCode);
        if (future != null) {
            future.cancel(true);
        }
    }

    public static void cancelPool(int requestCode) {
        PoolRequest pool = (PoolRequest)poolRequests.get(requestCode);
        if (pool != null) {
            pool.cancel();
        }
    }

    static {
        requests = new SparseArray();
        poolRequests = new SparseArray();
    }

    public static class Config {
        public static final String HTTP = "http";
        public static final String HTTPS = "https";
        private Set<Integer> successStatusCodes = new HashSet<Integer>(Collections.singletonList(200));
        private int timeout = 60000;
        private String scheme = "http";
        private String host;
        private int port = -1;
        @Nullable
        private BasicAuthorization basicAuthorization;
        @Nullable
        private InitialRequirements initialRequirements;
        private Logger logger = new LogcatLogger();
        @NonNull
        private ErrorDeserializer errorDeserializer = new JsonErrorDeserializer();
        @NonNull
        private Deserializer deserializer = new JsonDeserializer();
        @NonNull
        private Serializer serializer = new ObjectToFormSerializer();
        private RestAuthorizationService userService;
        private Class<? extends DefaultErrorResponse> errorResponseClass;
        private RestAuthorizationService restAuthorizationService;
        private Map<String, String> headers = new HashMap<String, String>();
        private ErrorCallback errorCallback;

        public int getTimeout() {
            return this.timeout;
        }

        public Config setTimeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public String getScheme() {
            return this.scheme;
        }

        public Config setScheme(@NonNull String scheme) {
            this.scheme = scheme;
            return this;
        }

        public String getHost() {
            return this.host;
        }

        public Config setHost(@NonNull String host) {
            this.host = host;
            return this;
        }

        public int getPort() {
            return this.port;
        }

        public Config setPort(int port) {
            this.port = port;
            return this;
        }

        @Nullable
        public BasicAuthorization getBasicAuthorization() {
            return this.basicAuthorization;
        }

        public Config setAuthorization(@NonNull String user, @NonNull String password) {
            if (TextUtils.isEmpty((CharSequence)user) || TextUtils.isEmpty((CharSequence)password)) {
                this.basicAuthorization = null;
                return this;
            }
            this.basicAuthorization = new BasicAuthorization(user, password);
            return this;
        }

        @Nullable
        public InitialRequirements getInitialRequirements() {
            return this.initialRequirements;
        }

        public Config setInitialRequirements(@NonNull InitialRequirements initialRequirements) {
            this.initialRequirements = initialRequirements;
            return this;
        }

        @NonNull
        public Deserializer getDeserializer() {
            return this.deserializer;
        }

        public Config setDeserializer(@NonNull Deserializer deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        @NonNull
        public Serializer getSerializer() {
            return this.serializer;
        }

        public Config setSerializer(@NonNull Serializer serializer) {
            this.serializer = serializer;
            return this;
        }

        @Nullable
        public RestAuthorizationService getRestAuthorizationService() {
            return this.restAuthorizationService;
        }

        public Config setRestAuthorizationService(RestAuthorizationService authorizationService) {
            this.restAuthorizationService = authorizationService;
            return this;
        }

        @NonNull
        public ErrorDeserializer getErrorDeserializer() {
            return this.errorDeserializer;
        }

        public Config setErrorDeserializer(@NonNull ErrorDeserializer errorDeserializer) {
            this.errorDeserializer = errorDeserializer;
            return this;
        }

        public Config setLogLevel(@NonNull Level level) {
            ((LogcatLogger)this.logger).setConfig((LogcatLoggerConfig)new LogcatLoggerConfig().setLevel(level));
            return this;
        }

        public Config addHeader(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Config removeHeader(String name) {
            this.headers.remove(name);
            return this;
        }

        @NonNull
        public Map<String, String> getHeaders() {
            return this.headers;
        }

        @Nullable
        public ErrorCallback getErrorCallback() {
            return this.errorCallback;
        }

        public Config setErrorCallback(@Nullable ErrorCallback errorCallback) {
            this.errorCallback = errorCallback;
            return this;
        }

        public Set<Integer> getSuccessStatusCodes() {
            return this.successStatusCodes;
        }

        public Config setSuccessStatusCodes(Set<Integer> successStatusCodes) {
            this.successStatusCodes = successStatusCodes;
            return this;
        }

        public Config setSuccessStatusCodes(int ... successStatusCodes) {
            this.successStatusCodes = new HashSet<Integer>();
            for (int code : successStatusCodes) {
                this.successStatusCodes.add(code);
            }
            return this;
        }
    }

    public static class PoolBuilder {
        protected Map<Integer, Request> requestPool = new LinkedHashMap<Integer, Request>();
        private int executor;

        public PoolBuilder(int executor) {
            this.executor = executor;
        }

        public PoolRequest build() {
            PoolRequest poolRequest;
            switch (this.executor) {
                case 1: {
                    poolRequest = new ThreadPoolRequest(this.requestPool.size());
                    break;
                }
                default: {
                    poolRequest = new SerialPoolRequest();
                }
            }
            for (Map.Entry<Integer, Request> entry : this.requestPool.entrySet()) {
                poolRequest.addTask(entry.getValue(), entry.getKey());
            }
            return poolRequest;
        }

        public void execute(RequestPoolListener listener) {
            PoolRequest poolRequest = this.build();
            poolRequest.execute(listener);
        }

        public void execute(final RequestPoolListener listener, final int requestCode) {
            PoolRequest poolRequest = this.build();
            poolRequest.execute(new RequestPoolListener(){

                @Override
                public void onSuccess(@NonNull Map<Integer, Object> result) {
                    listener.onSuccess(result);
                }

                @Override
                public boolean onFailed(RequestException e, int requestCode2) {
                    return listener.onFailed(e, requestCode2);
                }

                @Override
                public void onPreExecute() {
                    listener.onPreExecute();
                }

                @Override
                public void onTaskSuccess(Object result, int requestCode2) {
                    listener.onTaskSuccess(result, requestCode2);
                }

                @Override
                public void onPostExecute() {
                    listener.onPostExecute();
                    poolRequests.delete(requestCode);
                }

                @Override
                public void onCancel() {
                    listener.onCancel();
                }
            });
            poolRequests.put(requestCode, (Object)poolRequest);
        }

        public PoolBuilder add(@NonNull Request request, int requestCode) {
            this.requestPool.put(requestCode, request);
            return this;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Executor {
    }
}

