/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi.serialization;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import software.rsquared.restapi.exceptions.DeserializationException;
import software.rsquared.restapi.serialization.Deserializer;

public class JsonDeserializer
implements Deserializer {
    protected final ObjectMapper objectMapper = new ObjectMapper();
    protected final Config config;

    public JsonDeserializer() {
        this(new Config());
    }

    public JsonDeserializer(@NonNull Config config) {
        this.config = config;
        this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        SimpleModule module = new SimpleModule();
        this.setupModule(module);
        this.objectMapper.registerModule((Module)module);
    }

    @CallSuper
    protected void setupModule(SimpleModule module) {
        if (this.config.timeInSeconds) {
            module.addDeserializer(Calendar.class, (com.fasterxml.jackson.databind.JsonDeserializer)new com.fasterxml.jackson.databind.JsonDeserializer<Calendar>(){

                public Calendar deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    if (TextUtils.isEmpty((CharSequence)p.getText())) {
                        return null;
                    }
                    long value = p.getLongValue();
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeInMillis(value * 1000L);
                    return calendar;
                }
            });
            module.addDeserializer(Date.class, (com.fasterxml.jackson.databind.JsonDeserializer)new com.fasterxml.jackson.databind.JsonDeserializer<Date>(){

                public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                    if (TextUtils.isEmpty((CharSequence)p.getText())) {
                        return null;
                    }
                    long value = p.getLongValue();
                    return new Date(value * 1000L);
                }
            });
        }
        module.addDeserializer(Boolean.class, (com.fasterxml.jackson.databind.JsonDeserializer)new com.fasterxml.jackson.databind.JsonDeserializer<Boolean>(){

            public Boolean deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                if (TextUtils.isEmpty((CharSequence)p.getText())) {
                    return null;
                }
                String valueText = p.getText();
                try {
                    return Integer.parseInt(valueText) > 0;
                }
                catch (NumberFormatException e) {
                    return Boolean.parseBoolean(valueText);
                }
            }
        });
        module.addDeserializer(Boolean.TYPE, (com.fasterxml.jackson.databind.JsonDeserializer)new com.fasterxml.jackson.databind.JsonDeserializer<Boolean>(){

            public Boolean deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                if (TextUtils.isEmpty((CharSequence)p.getText())) {
                    throw new IOException("Cannot deserialize null primitive value");
                }
                String valueText = p.getText();
                try {
                    return Integer.parseInt(valueText) > 0;
                }
                catch (NumberFormatException ignored) {
                    return Boolean.parseBoolean(valueText);
                }
            }
        });
        module.addDeserializer(boolean[].class, (com.fasterxml.jackson.databind.JsonDeserializer)new com.fasterxml.jackson.databind.JsonDeserializer<boolean[]>(){

            public boolean[] deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
                String[] value = (String[])p.readValueAs(String[].class);
                if (value == null) {
                    return null;
                }
                boolean[] array = new boolean[value.length];
                for (int i = 0; i < value.length; ++i) {
                    String valueText = value[i];
                    try {
                        array[i] = Integer.parseInt(valueText) > 0;
                        continue;
                    }
                    catch (NumberFormatException ignored) {
                        array[i] = Boolean.parseBoolean(valueText);
                    }
                }
                return array;
            }
        });
    }

    @Override
    public <T> T read(Class<?> requestClass, String content) throws IOException {
        Type superclass = requestClass.getGenericSuperclass();
        while (!(superclass instanceof ParameterizedType) && requestClass.getSuperclass() != null) {
            requestClass = requestClass.getSuperclass();
            superclass = requestClass.getGenericSuperclass();
        }
        if (superclass != null && superclass instanceof ParameterizedType) {
            return this.readObject(this.getParameterClasses((ParameterizedType)superclass).get(0), content);
        }
        throw new DeserializationException("Unknown parameter response class for " + requestClass.getSimpleName());
    }

    protected <T> T readObject(TypeDescription description, String content) throws IOException {
        if (TextUtils.isEmpty((CharSequence)content)) {
            content = this.getEmptyJson(description.type);
        }
        if (description.parameters != null) {
            return (T)this.objectMapper.readerFor(this.getJavaType(description)).readValue(content);
        }
        return (T)this.objectMapper.readerFor(description.type).readValue(content);
    }

    @Nullable
    protected JavaType getJavaType(TypeDescription description) {
        if (description.parameters != null) {
            if (Collection.class.isAssignableFrom(description.type)) {
                return this.objectMapper.getTypeFactory().constructCollectionType(description.type, this.getJavaType(description.parameters.get(0)));
            }
            if (Map.class.isAssignableFrom(description.type)) {
                return this.objectMapper.getTypeFactory().constructMapType(description.type, this.getJavaType(description.parameters.get(0)), this.getJavaType(description.parameters.get(1)));
            }
            JavaType[] types = new JavaType[description.parameters.size()];
            for (int i = 0; i < description.parameters.size(); ++i) {
                types[i] = this.getJavaType(description.parameters.get(i));
            }
            return this.objectMapper.getTypeFactory().constructParametricType(description.type, types);
        }
        return this.objectMapper.getTypeFactory().constructSimpleType(description.type, null);
    }

    protected String getEmptyJson(@NonNull Object object) {
        if (object instanceof Class && this.isArray((Class)object)) {
            return "[]";
        }
        return "{}";
    }

    protected boolean isArray(@NonNull Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz) || clazz.isArray();
    }

    protected List<TypeDescription> getParameterClasses(@NonNull ParameterizedType type) {
        ArrayList<TypeDescription> descriptions = new ArrayList<TypeDescription>();
        Type[] arguments = type.getActualTypeArguments();
        for (int i = 0; i < arguments.length; ++i) {
            Type subType = arguments[i];
            if (subType instanceof Class) {
                descriptions.add(new TypeDescription((Class)subType));
                continue;
            }
            if (!(subType instanceof ParameterizedType)) continue;
            descriptions.add(new TypeDescription((Class)((ParameterizedType)subType).getRawType(), this.getParameterClasses((ParameterizedType)subType)));
        }
        return descriptions;
    }

    protected class TypeDescription {
        Class<?> type;
        List<TypeDescription> parameters;

        public TypeDescription(Class<?> type) {
            this.type = type;
        }

        public TypeDescription(Class<?> type, List<TypeDescription> parameters) {
            this.type = type;
            this.parameters = parameters;
        }
    }

    public static class Config {
        private boolean timeInSeconds;

        public Config setTimeInSeconds(boolean timeInSeconds) {
            this.timeInSeconds = timeInSeconds;
            return this;
        }
    }
}

