/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.restapi.serialization;

import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import software.rsquared.restapi.Parameter;
import software.rsquared.restapi.RestObject;
import software.rsquared.restapi.serialization.Serializer;

public class JsonSerializer
implements Serializer {
    private final ObjectMapper mObjectMapper = new ObjectMapper();
    private final Config mConfig;

    public JsonSerializer() {
        this(new Config());
    }

    public JsonSerializer(@NonNull Config config) {
        this.mConfig = config;
        this.mObjectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        SimpleModule module = new SimpleModule();
        this.setupModule(module);
        this.mObjectMapper.registerModule((Module)module);
        if (!this.mConfig.mNullValues) {
            this.mObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
    }

    @CallSuper
    protected void setupModule(SimpleModule module) {
        module.addSerializer(File.class, (com.fasterxml.jackson.databind.JsonSerializer)new com.fasterxml.jackson.databind.JsonSerializer<File>(){

            public void serialize(File value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                gen.writeString("_file{" + value.getAbsolutePath() + "}");
            }
        });
        if (this.mConfig.mIntBoolean) {
            module.addSerializer(Boolean.class, (com.fasterxml.jackson.databind.JsonSerializer)new com.fasterxml.jackson.databind.JsonSerializer<Boolean>(){

                public void serialize(Boolean value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (value != null) {
                        gen.writeNumber(value != false ? 1 : 0);
                    }
                }
            });
            module.addSerializer(Boolean.TYPE, (com.fasterxml.jackson.databind.JsonSerializer)new com.fasterxml.jackson.databind.JsonSerializer<Boolean>(){

                public void serialize(Boolean value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    gen.writeNumber(value != false ? 1 : 0);
                }
            });
            module.addSerializer(boolean[].class, (com.fasterxml.jackson.databind.JsonSerializer)new com.fasterxml.jackson.databind.JsonSerializer<boolean[]>(){

                public void serialize(boolean[] value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    int[] array = new int[value.length];
                    for (int i = 0; i < value.length; ++i) {
                        Boolean aBoolean = value[i];
                        array[i] = aBoolean != false ? 1 : 0;
                    }
                    gen.writeArray(array, 0, array.length);
                }
            });
        }
        if (this.mConfig.mTimeInSeconds) {
            module.addSerializer(Calendar.class, (com.fasterxml.jackson.databind.JsonSerializer)new com.fasterxml.jackson.databind.JsonSerializer<Calendar>(){

                public void serialize(Calendar value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (value != null) {
                        gen.writeNumber(value.getTimeInMillis() / 1000L);
                    }
                }
            });
            module.addSerializer(Date.class, (com.fasterxml.jackson.databind.JsonSerializer)new com.fasterxml.jackson.databind.JsonSerializer<Date>(){

                public void serialize(Date value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    if (value != null) {
                        gen.writeNumber(value.getTime() / 1000L);
                    }
                }
            });
        }
    }

    @Override
    public <T> List<Parameter> serialize(T object) {
        String name = null;
        if (this.isRestObject(object.getClass())) {
            name = this.getObjectName(object);
        }
        return this.serialize(name, object);
    }

    @Override
    public <T> List<Parameter> serialize(@Nullable String name, T object) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        JsonNode jsonNode = this.mObjectMapper.valueToTree(object);
        this.addParameter(name, jsonNode, parameters);
        return parameters;
    }

    private void addParameter(String name, JsonNode jsonNode, List<Parameter> parameters) {
        if (jsonNode.isArray()) {
            for (int i = 0; i < jsonNode.size(); ++i) {
                JsonNode child = jsonNode.get(i);
                if (child.isNull()) continue;
                String key = name == null ? "[" + i + "]" : name + "[" + i + "]";
                this.addParameter(key, child, parameters);
            }
        } else if (jsonNode.isObject()) {
            Iterator fields = jsonNode.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                String key = name == null ? (String)entry.getKey() : name + "[" + (String)entry.getKey() + "]";
                this.addParameter(key, (JsonNode)entry.getValue(), parameters);
            }
        } else {
            parameters.add(new Parameter(name, jsonNode.asText()));
        }
    }

    private <T> String getObjectName(T object) {
        RestObject restObject = object.getClass().getAnnotation(RestObject.class);
        if (!TextUtils.isEmpty((CharSequence)restObject.value())) {
            return restObject.value();
        }
        return object.getClass().getSimpleName();
    }

    private boolean isRestObject(Class<?> aClass) {
        return aClass.getAnnotation(RestObject.class) != null;
    }

    public static class Config {
        private boolean mTimeInSeconds;
        private boolean mIntBoolean;
        private boolean mNullValues;

        public Config setTimeInSeconds(boolean timeInSeconds) {
            this.mTimeInSeconds = timeInSeconds;
            return this;
        }

        public Config setIntBoolean(boolean intBoolean) {
            this.mIntBoolean = intBoolean;
            return this;
        }

        public Config setSerializeNullValues(boolean nonNullValues) {
            this.mNullValues = nonNullValues;
            return this;
        }
    }
}

