/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger.textview;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.widget.TextView;
import software.rsquared.androidlogger.Appender;
import software.rsquared.androidlogger.ConfigurableAppender;
import software.rsquared.androidlogger.Level;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.logcat.LogcatAppender;
import software.rsquared.androidlogger.textview.TextViewAppenderConfig;

public class TextViewAppender
extends Appender
implements ConfigurableAppender<TextViewAppenderConfig> {
    private final Logger logger = Logger.createWith(new LogcatAppender());
    private TextViewAppenderConfig config;
    @Nullable
    private TextView textView;

    public TextViewAppender() {
    }

    public TextViewAppender(@Nullable TextView textView) {
        this.textView = textView;
    }

    @Override
    public TextViewAppenderConfig getConfig() {
        if (this.config == null) {
            this.config = new TextViewAppenderConfig();
        }
        return this.config;
    }

    public TextViewAppender setTextView(@Nullable TextView textView) {
        this.textView = textView;
        return this;
    }

    @Override
    protected void append(Level level, String tag, String message) {
        if (this.textView != null) {
            Spannable spannable = this.convertToSpannable(this.textView, level, tag, message);
            if (TextViewAppenderConfig.Method.APPEND.equals((Object)this.config.getPrintMethod())) {
                this.textView.append((CharSequence)spannable);
            } else {
                this.textView.setText((CharSequence)spannable);
            }
        } else {
            this.logger.w((Object)("Text view in " + TextViewAppender.class.getSimpleName() + " is not initialized (call setTextView(TextView) method)"));
        }
    }

    @NonNull
    private Spannable convertToSpannable(@NonNull TextView textView, @NonNull Level level, String tag, String message) {
        String text;
        switch (this.config.getPrintMethod()) {
            case OVERWRITE: {
                text = tag + " " + message;
                break;
            }
            case PREPEND: {
                text = tag + " " + message + this.getMessageSeparator(textView) + textView.getText();
                break;
            }
            default: {
                text = this.getMessageSeparator(textView) + tag + " " + message;
            }
        }
        SpannableString spannable = new SpannableString((CharSequence)text);
        spannable.setSpan((Object)new ForegroundColorSpan(this.config.getColorScheme().getColor(level)), 0, spannable.length(), 33);
        return spannable;
    }

    private String getMessageSeparator(@NonNull TextView textView) {
        if (textView.length() <= 0) {
            return "";
        }
        if (this.config.isInNewLine()) {
            return "\n";
        }
        return " ";
    }
}

