/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class WordUtils {
    private WordUtils() {
    }

    public static String[] wrap(String str, int wrapLength) {
        if (str == null) {
            return null;
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        Pattern patternToWrapOn = Pattern.compile("\\s");
        int inputLineLength = str.length();
        int offset = 0;
        ArrayList<String> wrappedLines = new ArrayList<String>();
        while (offset < inputLineLength) {
            int spaceToWrapAt = -1;
            Matcher matcher = patternToWrapOn.matcher(str.substring(offset, Math.min(offset + wrapLength + 1, inputLineLength)));
            if (matcher.find()) {
                if (matcher.start() == 0) {
                    offset += matcher.end();
                    continue;
                }
                spaceToWrapAt = matcher.start();
            }
            if (inputLineLength - offset <= wrapLength) break;
            while (matcher.find()) {
                spaceToWrapAt = matcher.start() + offset;
            }
            if (spaceToWrapAt >= offset) {
                wrappedLines.add(str.substring(offset, spaceToWrapAt + 1));
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLines.add(str.substring(offset, wrapLength + offset));
            offset += wrapLength;
        }
        wrappedLines.add(str.substring(offset));
        return wrappedLines.toArray(new String[0]);
    }
}

