/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger.toast;

import android.support.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import software.rsquared.androidlogger.AppenderConfig;

public class ToastAppenderConfig
extends AppenderConfig<ToastAppenderConfig> {
    private int duration = 0;

    ToastAppenderConfig() {
    }

    public ToastAppenderConfig setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public int getDuration() {
        return this.duration;
    }

    @Override
    protected void read(@NonNull Map<String, String> config) {
        super.read(config);
        if (config.containsKey("duration")) {
            switch (config.get("duration")) {
                case "LENGTH_SHORT": {
                    this.setDuration(0);
                    break;
                }
                case "LENGTH_LONG": {
                    this.setDuration(1);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal duration length. Must be one of: SHORT, LONG");
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Duration {
    }
}

