/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger.toast;

import android.support.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import software.rsquared.androidlogger.BaseLoggerConfig;

public class ToastLoggerConfig
extends BaseLoggerConfig<ToastLoggerConfig> {
    private int duration = 0;

    public ToastLoggerConfig setDuration(int duration) {
        this.duration = duration;
        return this;
    }

    public int getDuration() {
        return this.duration;
    }

    @Override
    protected void read(@NonNull Map<String, String> config) {
        super.read(config);
        if (config.containsKey("duration")) {
            switch (config.get("duration")) {
                case "SHORT": {
                    this.setDuration(0);
                    break;
                }
                case "LONG": {
                    this.setDuration(0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal duration length. Must be one of: SHORT, LONG");
                }
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Duration {
    }
}

