/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger.file;

import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import software.rsquared.androidlogger.BaseLoggerConfig;

public abstract class BaseFileLoggerConfig<E extends BaseLoggerConfig<E>>
extends BaseLoggerConfig<E> {
    public static final String DATE_PATTERN = "dd_MM_yyyy";
    public static final String DATE = "$Date$";
    private File logFile = null;
    @NonNull
    private String datePattern = "dd_MM_yyyy";
    @NonNull
    private DateFormat dateFormat = new SimpleDateFormat(this.datePattern, Locale.getDefault());
    private String logFilePath;

    public File getLogFile() {
        return this.logFile;
    }

    public E setLogFile(@Nullable File logFile, boolean overwritePath) {
        if (logFile == null) {
            this.logFile = null;
            if (overwritePath) {
                this.logFilePath = null;
            }
        } else {
            if (overwritePath) {
                this.logFilePath = logFile.getAbsolutePath();
                if (logFile.getAbsolutePath().contains(DATE)) {
                    logFile = new File(this.invalidatePath(logFile.getAbsolutePath()));
                }
            }
            this.logFile = logFile;
        }
        return (E)this;
    }

    public E setLogFile(@Nullable File logFile) {
        return this.setLogFile(logFile, true);
    }

    public E setLogFile(@Nullable String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return this.setLogFile(null, true);
        }
        this.logFilePath = path;
        return this.setLogFile(new File(this.invalidatePath(path)), false);
    }

    public E setExternalLogFile(@Nullable String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return this.setLogFile(null, true);
        }
        return this.setLogFile(new File(Environment.getExternalStorageDirectory(), this.invalidatePath(path)), true);
    }

    private String invalidatePath(@NonNull String path) {
        return path.replace(DATE, this.dateFormat.format(new Date()));
    }

    @Override
    protected void read(@NonNull Map<String, String> config) {
        super.read(config);
        if (config.containsKey("externalFile")) {
            this.setExternalLogFile(config.get("externalFile"));
        }
        if (config.containsKey("datePattern")) {
            this.setDatePattern(config.get("datePattern"));
        }
    }

    @NonNull
    public String getDatePattern() {
        return this.datePattern;
    }

    public E setDatePattern(@NonNull String datePattern) {
        this.datePattern = datePattern;
        return this.setDateFormat(new SimpleDateFormat(datePattern, Locale.getDefault()));
    }

    @NonNull
    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public E setDateFormat(@NonNull DateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.setLogFile(this.logFilePath);
        return (E)this;
    }
}

