/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger.file;

import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import software.rsquared.androidlogger.Level;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.file.BaseFileLoggerConfig;
import software.rsquared.androidlogger.logcat.LogcatLogger;

public abstract class BaseFileLogger
extends Logger {
    protected static final LogcatLogger logger = new LogcatLogger();
    protected static final String DEFAULT_LOG_FILE = "logger.log";

    @Override
    protected void print(Level level, String message) {
        try {
            this.writeToFile(this.createFileIfNeeded(), this.getMessage(level, message));
        }
        catch (IOException e) {
            logger.e(e);
        }
    }

    @NonNull
    protected String getMessage(Level level, String message) {
        return this.getTag(level) + " " + message + "\n";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeToFile(File file, String string) {
        FileWriter writer = null;
        try {
            writer = new FileWriter(file, true);
            writer.write(string);
            this.close(writer);
        }
        catch (IOException e) {
            try {
                logger.e((Object)"Cannot write log to file", e);
                this.close(writer);
            }
            catch (Throwable throwable) {
                this.close(writer);
                throw throwable;
            }
        }
    }

    public synchronized void clearLogFile() {
        RandomAccessFile file = null;
        try {
            file = new RandomAccessFile(this.getLogFile(), "rw");
            file.setLength(0L);
            this.close(file);
        }
        catch (IOException e) {
            try {
                logger.e((Object)"Cannot clear Log file", e);
                this.close(file);
            }
            catch (Throwable throwable) {
                this.close(file);
                throw throwable;
            }
        }
    }

    @NonNull
    protected File createFileIfNeeded() throws IOException {
        File file = this.getLogFile();
        if (file.isDirectory()) {
            throw new IOException("The Log file cannot be directory");
        }
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IOException("Cannot create directory of the Log file");
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Cannot create Log file");
        }
        if (!file.canWrite()) {
            throw new IOException("File is not writable");
        }
        return file;
    }

    @NonNull
    public File getLogFile() {
        BaseFileLoggerConfig config = (BaseFileLoggerConfig)this.getConfig();
        File file = null;
        if (config != null) {
            file = config.getLogFile();
        }
        if (file == null) {
            file = new File(Environment.getExternalStorageDirectory(), DEFAULT_LOG_FILE);
        }
        return file;
    }

    protected void close(@Nullable Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.e((Object)"Failed to close file", e);
            }
        }
    }
}

