/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import com.github.anrwatchdog.ANRError;
import com.github.anrwatchdog.ANRWatchDog;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.logcat.LogcatLogger;

public class LoggableANRWatchDog
extends ANRWatchDog {
    private final LogcatLogger logger = new LogcatLogger();
    private ANRWatchDog.ANRListener customListener;
    private boolean preventCrash = false;

    public LoggableANRWatchDog() {
    }

    public LoggableANRWatchDog(int timeoutInterval) {
        super(timeoutInterval);
    }

    public LoggableANRWatchDog setANRListener(ANRWatchDog.ANRListener listener) {
        this.customListener = listener;
        return this;
    }

    public LoggableANRWatchDog preventCrash(boolean preventCrash) {
        this.preventCrash = preventCrash;
        return this;
    }

    public LoggableANRWatchDog setInterruptionListener(ANRWatchDog.InterruptionListener listener) {
        super.setInterruptionListener(listener);
        return this;
    }

    public LoggableANRWatchDog setReportThreadNamePrefix(String prefix) {
        super.setReportThreadNamePrefix(prefix);
        return this;
    }

    public LoggableANRWatchDog setReportMainThreadOnly() {
        super.setReportMainThreadOnly();
        return this;
    }

    @Deprecated
    public synchronized void start() {
        this.logger.w((Object)"=======================================");
        this.logger.w((Object)"LoggableANRWatchDog is running. Please use this carefully because the watchdog will prevent the debugger from hanging execution at breakpoints or exceptions (it will detect the debugging pause as an ANR).");
        this.logger.w((Object)"=======================================");
        super.setANRListener(new ANRWatchDog.ANRListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onAppNotResponding(ANRError error) {
                Logger.error((Throwable)error);
                if (LoggableANRWatchDog.this.customListener != null) {
                    try {
                        LoggableANRWatchDog.this.customListener.onAppNotResponding(error);
                        return;
                    }
                    catch (Error e) {
                        if (LoggableANRWatchDog.this.preventCrash) return;
                        throw e;
                    }
                } else {
                    if (LoggableANRWatchDog.this.preventCrash) return;
                    throw error;
                }
            }
        });
        super.start();
    }
}

