/*
 * Decompiled with CFR 0.152.
 */
package software.rsquared.androidlogger;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.RawRes;
import android.text.TextUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import software.rsquared.androidlogger.Logger;
import software.rsquared.androidlogger.LoggerUtils;
import software.rsquared.androidlogger.logcat.LogcatLogger;

public class ConfigReader {
    private static final String LOGGER_CONFIG_PREFIX = "logger";
    private static final Set<String> RESERVED_PROPERTIES = new HashSet<String>(Arrays.asList("logger.level", "logger.separator", "logger.throwableSeparator", "logger.tag", "logger.logThrowableWithStackTrace", "logger.datePattern", "logger.catchUncaughtExceptions", "logger.useANRWatchDog"));
    private final LogcatLogger logger = new LogcatLogger();
    private Map<String, Logger> loggers = new HashMap<String, Logger>();
    private Map<String, String> configMap = new HashMap<String, String>();

    private ConfigReader(@RawRes int propertiesRes) {
        Properties properties = new Properties();
        this.loadProperties(properties, propertiesRes);
        String value = properties.getProperty(LOGGER_CONFIG_PREFIX);
        if (value != null) {
            this.readLoggers(properties, value);
        }
        this.readBaseConfig(properties);
    }

    public static ConfigReader read(int propertiesRes) {
        return new ConfigReader(propertiesRes);
    }

    public Map<String, Logger> getLoggers() {
        return this.loggers;
    }

    public Map<String, String> getBaseConfigMap() {
        return this.configMap;
    }

    private void readBaseConfig(Properties properties) {
        this.addConfigProperty(properties, "logger.level");
        this.addConfigProperty(properties, "logger.separator");
        this.addConfigProperty(properties, "logger.throwableSeparator");
        this.addConfigProperty(properties, "logger.tag");
        this.addConfigProperty(properties, "logger.logThrowableWithStackTrace");
        this.addConfigProperty(properties, "logger.datePattern");
        this.addConfigProperty(properties, "logger.catchUncaughtExceptions");
        this.addConfigProperty(properties, "logger.useANRWatchDog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadProperties(Properties properties, @RawRes int propertiesRes) {
        Context context = LoggerUtils.getApplicationContext();
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(context.getResources().openRawResource(propertiesRes), "UTF-8");
            properties.load(reader);
        }
        catch (IOException e) {
            this.logger.w(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    this.logger.w(e);
                }
            }
        }
    }

    private void readLoggers(Properties properties, String loggerProperty) {
        String[] loggers = loggerProperty.split(",");
        Map<String, Map<String, String>> loggersMap = this.createLoggersMap(loggers);
        this.readProperties(properties, loggersMap);
        this.createLoggers(loggersMap);
    }

    private void addConfigProperty(Properties properties, String property) {
        String value = properties.getProperty(property);
        if (value != null) {
            this.configMap.put(property.substring(LOGGER_CONFIG_PREFIX.length() + 1), value);
        }
    }

    @NonNull
    private Map<String, Map<String, String>> createLoggersMap(String[] loggers) {
        HashMap<String, Map<String, String>> loggersMap = new HashMap<String, Map<String, String>>();
        for (String logger : loggers) {
            logger = logger.trim();
            this.checkLoggerName(logger);
            loggersMap.put(logger, new HashMap());
        }
        return loggersMap;
    }

    private void readProperties(Properties properties, Map<String, Map<String, String>> loggersMap) {
        Enumeration<?> propertyKeys = properties.propertyNames();
        while (propertyKeys.hasMoreElements()) {
            String key = (String)propertyKeys.nextElement();
            if (RESERVED_PROPERTIES.contains(key) || LOGGER_CONFIG_PREFIX.equals(key)) continue;
            String loggerName = key.substring(key.indexOf(".") + 1);
            String propertyName = "";
            String propertyValue = properties.getProperty(key);
            int propertyIdx = loggerName.indexOf(".");
            if (propertyIdx > 0) {
                propertyName = loggerName.substring(propertyIdx + 1);
                loggerName = loggerName.substring(0, propertyIdx);
            }
            if (!loggersMap.containsKey(loggerName)) continue;
            loggersMap.get(loggerName).put(propertyName, propertyValue);
        }
    }

    private void checkLoggerName(String logger) {
        if (TextUtils.isEmpty((CharSequence)logger)) {
            throw new IllegalArgumentException("You must specified logger name");
        }
        if (RESERVED_PROPERTIES.contains("logger." + logger)) {
            throw new IllegalArgumentException("Logger cannot be named as " + logger);
        }
    }

    private void createLoggers(Map<String, Map<String, String>> loggersMap) {
        for (Map.Entry<String, Map<String, String>> entry : loggersMap.entrySet()) {
            String clazz = entry.getValue().get("");
            entry.getValue().remove("");
            this.addLogger(clazz, entry.getKey(), entry.getValue());
        }
    }

    private void addLogger(String loggerClass, String loggerTag, Map<String, String> configMap) {
        try {
            Class<?> clazz = Class.forName(loggerClass);
            Logger l = (Logger)clazz.newInstance();
            l.loggerTag = loggerTag;
            l.init(configMap);
            this.loggers.put(loggerTag, l);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Logger class '" + loggerClass + "' not found");
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(loggerClass + " must have public 0 args constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(loggerClass + " must have public 0 args constructor");
        }
    }
}

