/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.util;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Base64;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.codec.multipart.FilePart;
import reactor.core.publisher.Mono;
import software.crldev.elrondspringbootstarterreactive.error.exception.InvalidPemFileException;

public class PemUtils {
    public static String extractKeyHex(File pem) {
        try {
            return PemUtils.processPem(new FileReader(pem));
        }
        catch (Exception e) {
            throw new InvalidPemFileException(e);
        }
    }

    public static Mono<String> extractKeyHex(FilePart pem) {
        return pem.content().map(DataBuffer::asInputStream).next().map(is -> PemUtils.processPem(new InputStreamReader((InputStream)is)));
    }

    private static String processPem(Reader reader) {
        try {
            PemObject pemObject = new PemReader(reader).readPemObject();
            String keyBase64 = Base64.getEncoder().encodeToString(pemObject.getContent());
            String privateKeyBase64 = keyBase64.substring(0, keyBase64.length() / 2);
            return new String(Base64.getDecoder().decode(privateKeyBase64));
        }
        catch (Exception e) {
            throw new InvalidPemFileException(e);
        }
    }
}

