/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.properties;

import java.util.Locale;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import software.crldev.elrondspringbootstarterreactive.error.exception.GatewayException;

@ConfigurationProperties(prefix="spring.elrond.client")
public class ErdClientProperties {
    private String gateway;
    private long readTimeoutMillis = 10000L;
    private long writeTimeoutMillis = 10000L;

    public void setGateway(String gateway) {
        switch (gateway.toLowerCase(Locale.ROOT).strip()) {
            case "devnet": {
                this.gateway = this.processUrl("devnet-gateway");
                break;
            }
            case "testnet": {
                this.gateway = this.processUrl("testnet-gateway");
                break;
            }
            case "mainnet": {
                this.gateway = this.processUrl("gateway");
                break;
            }
            default: {
                throw new GatewayException();
            }
        }
    }

    private String processUrl(String gatewayValue) {
        return String.format("https://%s.elrond.com", gatewayValue);
    }

    @Generated
    public ErdClientProperties() {
        this.setGateway("devnet");
    }

    @Generated
    public String getGateway() {
        return this.gateway;
    }

    @Generated
    public long getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    @Generated
    public long getWriteTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    @Generated
    public void setReadTimeoutMillis(long readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
    }

    @Generated
    public void setWriteTimeoutMillis(long writeTimeoutMillis) {
        this.writeTimeoutMillis = writeTimeoutMillis;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErdClientProperties)) {
            return false;
        }
        ErdClientProperties other = (ErdClientProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getReadTimeoutMillis() != other.getReadTimeoutMillis()) {
            return false;
        }
        if (this.getWriteTimeoutMillis() != other.getWriteTimeoutMillis()) {
            return false;
        }
        String this$gateway = this.getGateway();
        String other$gateway = other.getGateway();
        return !(this$gateway == null ? other$gateway != null : !this$gateway.equals(other$gateway));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ErdClientProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $readTimeoutMillis = this.getReadTimeoutMillis();
        result = result * 59 + (int)($readTimeoutMillis >>> 32 ^ $readTimeoutMillis);
        long $writeTimeoutMillis = this.getWriteTimeoutMillis();
        result = result * 59 + (int)($writeTimeoutMillis >>> 32 ^ $writeTimeoutMillis);
        String $gateway = this.getGateway();
        result = result * 59 + ($gateway == null ? 43 : $gateway.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ErdClientProperties(gateway=" + this.getGateway() + ", readTimeoutMillis=" + this.getReadTimeoutMillis() + ", writeTimeoutMillis=" + this.getWriteTimeoutMillis() + ")";
    }
}

