/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt.common;

import java.math.BigInteger;
import lombok.Generated;
import software.crldev.elrondspringbootstarterreactive.error.ErrorMessage;
import software.crldev.elrondspringbootstarterreactive.util.HexValidator;

public final class TokenInitialSupply {
    private final BigInteger supply;

    private TokenInitialSupply(BigInteger supply) {
        this.supply = supply;
    }

    public static TokenInitialSupply fromNumber(BigInteger supply) {
        TokenInitialSupply.verifySupply(supply);
        return new TokenInitialSupply(supply);
    }

    public static TokenInitialSupply fromString(String supply) {
        BigInteger supplyNumber = new BigInteger(supply.strip());
        TokenInitialSupply.verifySupply(supplyNumber);
        return TokenInitialSupply.fromNumber(supplyNumber);
    }

    public String getHex() {
        return HexValidator.processNumberHexArgument(this.supply.toString(16));
    }

    public String toString() {
        return this.supply.toString();
    }

    private static void verifySupply(BigInteger supply) {
        if (supply.signum() == -1 || supply.signum() == 0) {
            throw new IllegalArgumentException(ErrorMessage.INITIAL_SUPPLY.getValue());
        }
    }

    @Generated
    public BigInteger getSupply() {
        return this.supply;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenInitialSupply)) {
            return false;
        }
        TokenInitialSupply other = (TokenInitialSupply)o;
        BigInteger this$supply = this.getSupply();
        BigInteger other$supply = other.getSupply();
        return !(this$supply == null ? other$supply != null : !((Object)this$supply).equals(other$supply));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $supply = this.getSupply();
        result = result * 59 + ($supply == null ? 43 : ((Object)$supply).hashCode());
        return result;
    }
}

