/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bouncycastle.util.encoders.Hex;
import software.crldev.elrondspringbootstarterreactive.error.ErrorMessage;

public enum ESDTSpecialRole {
    ESDT_LOCAL_BURN("ESDTRoleLocalBurn"),
    ESDT_LOCAL_MINT("ESDTRoleLocalMint"),
    ESDT_TRANSFER("ESDTTransferRole"),
    ESDT_NFT_CREATE("ESDTRoleNFTCreate"),
    ESDT_NFT_BURN("ESDTRoleNFTBurn"),
    ESDT_NFT_ADD_QUANTITY("ESDTRoleNFTAddQuantity"),
    ESDT_NFT_UPDATE_ATTRIBUTES("ESDTRoleNFTUpdateAttributes"),
    ESDT_NFT_ADD_URI("ESDTRoleNFTAddURI");

    private static final Map<String, ESDTSpecialRole> BY_VALUE;
    private final String hex;
    private final String value;

    private ESDTSpecialRole(String value) {
        this.value = value;
        this.hex = Hex.toHexString((byte[])value.getBytes());
    }

    public static ESDTSpecialRole getByValue(String value) {
        return Optional.ofNullable(BY_VALUE.get(value)).orElseThrow(() -> new IllegalArgumentException(ErrorMessage.TOKEN_ROLE.getValue()));
    }

    @Generated
    public String getHex() {
        return this.hex;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    static {
        BY_VALUE = new HashMap<String, ESDTSpecialRole>();
        for (ESDTSpecialRole e : ESDTSpecialRole.values()) {
            BY_VALUE.put(e.value, e);
        }
    }
}

