/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt;

import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.ESDTTransaction;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenIdentifier;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.TransactionRequest;

public final class NFTStopCreation
implements ESDTTransaction {
    @NonNull
    private final TokenIdentifier tokenIdentifier;
    @NonNull
    private final GasLimit gasLimit;

    private PayloadData processPayloadData() {
        return PayloadData.fromString(String.format("%s@%s", "stopNFTCreate", this.tokenIdentifier.getHex()));
    }

    @Override
    public TransactionRequest toTransactionRequest(Wallet wallet) {
        return TransactionRequest.builder().receiverAddress(Address.fromBech32("erd1qqqqqqqqqqqqqqqpqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqzllls8a5w6u")).data(this.processPayloadData()).value(Balance.zero()).gasLimit(this.gasLimit).build();
    }

    @Generated
    private static GasLimit $default$gasLimit() {
        return GasLimit.defaultEsdtIssuance();
    }

    @Generated
    NFTStopCreation(@NonNull TokenIdentifier tokenIdentifier, @NonNull GasLimit gasLimit) {
        if (tokenIdentifier == null) {
            throw new NullPointerException("tokenIdentifier is marked non-null but is null");
        }
        if (gasLimit == null) {
            throw new NullPointerException("gasLimit is marked non-null but is null");
        }
        this.tokenIdentifier = tokenIdentifier;
        this.gasLimit = gasLimit;
    }

    @Generated
    public static NFTStopCreationBuilder builder() {
        return new NFTStopCreationBuilder();
    }

    @NonNull
    @Generated
    public TokenIdentifier getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    @NonNull
    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NFTStopCreation)) {
            return false;
        }
        NFTStopCreation other = (NFTStopCreation)o;
        TokenIdentifier this$tokenIdentifier = this.getTokenIdentifier();
        TokenIdentifier other$tokenIdentifier = other.getTokenIdentifier();
        if (this$tokenIdentifier == null ? other$tokenIdentifier != null : !((Object)this$tokenIdentifier).equals(other$tokenIdentifier)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        return !(this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TokenIdentifier $tokenIdentifier = this.getTokenIdentifier();
        result = result * 59 + ($tokenIdentifier == null ? 43 : ((Object)$tokenIdentifier).hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NFTStopCreation(tokenIdentifier=" + this.getTokenIdentifier() + ", gasLimit=" + this.getGasLimit() + ")";
    }

    @Generated
    public static class NFTStopCreationBuilder {
        @Generated
        private TokenIdentifier tokenIdentifier;
        @Generated
        private boolean gasLimit$set;
        @Generated
        private GasLimit gasLimit$value;

        @Generated
        NFTStopCreationBuilder() {
        }

        @Generated
        public NFTStopCreationBuilder tokenIdentifier(@NonNull TokenIdentifier tokenIdentifier) {
            if (tokenIdentifier == null) {
                throw new NullPointerException("tokenIdentifier is marked non-null but is null");
            }
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        @Generated
        public NFTStopCreationBuilder gasLimit(@NonNull GasLimit gasLimit) {
            if (gasLimit == null) {
                throw new NullPointerException("gasLimit is marked non-null but is null");
            }
            this.gasLimit$value = gasLimit;
            this.gasLimit$set = true;
            return this;
        }

        @Generated
        public NFTStopCreation build() {
            GasLimit gasLimit$value = this.gasLimit$value;
            if (!this.gasLimit$set) {
                gasLimit$value = NFTStopCreation.$default$gasLimit();
            }
            return new NFTStopCreation(this.tokenIdentifier, gasLimit$value);
        }

        @Generated
        public String toString() {
            return "NFTStopCreation.NFTStopCreationBuilder(tokenIdentifier=" + this.tokenIdentifier + ", gasLimit$value=" + this.gasLimit$value + ")";
        }
    }
}

