/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt;

import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.ESDTTransaction;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenIdentifier;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.TransactionRequest;

public final class NFTCreationRoleTransfer
implements ESDTTransaction {
    @NonNull
    private final TokenIdentifier tokenIdentifier;
    @NonNull
    private final Address fromAddress;
    @NonNull
    private final Address toAddress;
    @NonNull
    private final GasLimit gasLimit;

    private PayloadData processPayloadData() {
        return PayloadData.fromString(String.format("%s@%s@%s@%s", "transferNFTCreateRole", this.tokenIdentifier.getHex(), this.fromAddress.getHex(), this.toAddress.getHex()));
    }

    @Override
    public TransactionRequest toTransactionRequest(Wallet wallet) {
        return TransactionRequest.builder().receiverAddress(Address.fromBech32("erd1qqqqqqqqqqqqqqqpqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqzllls8a5w6u")).data(this.processPayloadData()).value(Balance.zero()).gasLimit(this.gasLimit).build();
    }

    @Generated
    private static GasLimit $default$gasLimit() {
        return GasLimit.defaultEsdtIssuance();
    }

    @Generated
    NFTCreationRoleTransfer(@NonNull TokenIdentifier tokenIdentifier, @NonNull Address fromAddress, @NonNull Address toAddress, @NonNull GasLimit gasLimit) {
        if (tokenIdentifier == null) {
            throw new NullPointerException("tokenIdentifier is marked non-null but is null");
        }
        if (fromAddress == null) {
            throw new NullPointerException("fromAddress is marked non-null but is null");
        }
        if (toAddress == null) {
            throw new NullPointerException("toAddress is marked non-null but is null");
        }
        if (gasLimit == null) {
            throw new NullPointerException("gasLimit is marked non-null but is null");
        }
        this.tokenIdentifier = tokenIdentifier;
        this.fromAddress = fromAddress;
        this.toAddress = toAddress;
        this.gasLimit = gasLimit;
    }

    @Generated
    public static NFTCreationRoleTransferBuilder builder() {
        return new NFTCreationRoleTransferBuilder();
    }

    @NonNull
    @Generated
    public TokenIdentifier getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    @NonNull
    @Generated
    public Address getFromAddress() {
        return this.fromAddress;
    }

    @NonNull
    @Generated
    public Address getToAddress() {
        return this.toAddress;
    }

    @NonNull
    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NFTCreationRoleTransfer)) {
            return false;
        }
        NFTCreationRoleTransfer other = (NFTCreationRoleTransfer)o;
        TokenIdentifier this$tokenIdentifier = this.getTokenIdentifier();
        TokenIdentifier other$tokenIdentifier = other.getTokenIdentifier();
        if (this$tokenIdentifier == null ? other$tokenIdentifier != null : !((Object)this$tokenIdentifier).equals(other$tokenIdentifier)) {
            return false;
        }
        Address this$fromAddress = this.getFromAddress();
        Address other$fromAddress = other.getFromAddress();
        if (this$fromAddress == null ? other$fromAddress != null : !this$fromAddress.equals(other$fromAddress)) {
            return false;
        }
        Address this$toAddress = this.getToAddress();
        Address other$toAddress = other.getToAddress();
        if (this$toAddress == null ? other$toAddress != null : !this$toAddress.equals(other$toAddress)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        return !(this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TokenIdentifier $tokenIdentifier = this.getTokenIdentifier();
        result = result * 59 + ($tokenIdentifier == null ? 43 : ((Object)$tokenIdentifier).hashCode());
        Address $fromAddress = this.getFromAddress();
        result = result * 59 + ($fromAddress == null ? 43 : $fromAddress.hashCode());
        Address $toAddress = this.getToAddress();
        result = result * 59 + ($toAddress == null ? 43 : $toAddress.hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NFTCreationRoleTransfer(tokenIdentifier=" + this.getTokenIdentifier() + ", fromAddress=" + this.getFromAddress() + ", toAddress=" + this.getToAddress() + ", gasLimit=" + this.getGasLimit() + ")";
    }

    @Generated
    public static class NFTCreationRoleTransferBuilder {
        @Generated
        private TokenIdentifier tokenIdentifier;
        @Generated
        private Address fromAddress;
        @Generated
        private Address toAddress;
        @Generated
        private boolean gasLimit$set;
        @Generated
        private GasLimit gasLimit$value;

        @Generated
        NFTCreationRoleTransferBuilder() {
        }

        @Generated
        public NFTCreationRoleTransferBuilder tokenIdentifier(@NonNull TokenIdentifier tokenIdentifier) {
            if (tokenIdentifier == null) {
                throw new NullPointerException("tokenIdentifier is marked non-null but is null");
            }
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        @Generated
        public NFTCreationRoleTransferBuilder fromAddress(@NonNull Address fromAddress) {
            if (fromAddress == null) {
                throw new NullPointerException("fromAddress is marked non-null but is null");
            }
            this.fromAddress = fromAddress;
            return this;
        }

        @Generated
        public NFTCreationRoleTransferBuilder toAddress(@NonNull Address toAddress) {
            if (toAddress == null) {
                throw new NullPointerException("toAddress is marked non-null but is null");
            }
            this.toAddress = toAddress;
            return this;
        }

        @Generated
        public NFTCreationRoleTransferBuilder gasLimit(@NonNull GasLimit gasLimit) {
            if (gasLimit == null) {
                throw new NullPointerException("gasLimit is marked non-null but is null");
            }
            this.gasLimit$value = gasLimit;
            this.gasLimit$set = true;
            return this;
        }

        @Generated
        public NFTCreationRoleTransfer build() {
            GasLimit gasLimit$value = this.gasLimit$value;
            if (!this.gasLimit$set) {
                gasLimit$value = NFTCreationRoleTransfer.$default$gasLimit();
            }
            return new NFTCreationRoleTransfer(this.tokenIdentifier, this.fromAddress, this.toAddress, gasLimit$value);
        }

        @Generated
        public String toString() {
            return "NFTCreationRoleTransfer.NFTCreationRoleTransferBuilder(tokenIdentifier=" + this.tokenIdentifier + ", fromAddress=" + this.fromAddress + ", toAddress=" + this.toAddress + ", gasLimit$value=" + this.gasLimit$value + ")";
        }
    }
}

