/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt;

import java.math.BigInteger;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.ESDTTransaction;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.ESDTUri;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenAttributes;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenIdentifier;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenInitialSupply;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenName;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenRoyalties;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.Hash;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.TransactionRequest;

public final class NFTCreation
implements ESDTTransaction {
    @NonNull
    private final TokenIdentifier tokenIdentifier;
    private final TokenInitialSupply initialQuantity;
    @NonNull
    private final TokenName nftName;
    @NonNull
    private final TokenRoyalties tokenRoyalties;
    @NonNull
    private final Hash hash;
    @NonNull
    private final TokenAttributes tokenAttributes;
    @NonNull
    private final Set<ESDTUri> uris;
    @NonNull
    private final GasLimit gasLimit;

    private PayloadData processPayloadData() {
        return PayloadData.fromString(String.format("%s@%s@%s@%s@%s@%s@%s@%s", "ESDTNFTCreate", this.tokenIdentifier.getHex(), this.initialQuantity.getHex(), this.nftName.getHex(), this.tokenRoyalties.getHex(), this.processHash(), this.tokenAttributes.getHex(), this.processUris()));
    }

    private String processHash() {
        return this.hash.isEmpty() ? "00" : this.hash.toString();
    }

    private String processUris() {
        if (this.uris.isEmpty()) {
            throw new IllegalArgumentException("List of URIs cannot be empty");
        }
        return this.uris.stream().map(ESDTUri::getHex).collect(Collectors.joining("@"));
    }

    @Override
    public TransactionRequest toTransactionRequest(Wallet wallet) {
        return TransactionRequest.builder().receiverAddress(wallet.getAddress()).data(this.processPayloadData()).value(Balance.zero()).gasLimit(this.gasLimit).build();
    }

    @Generated
    private static TokenInitialSupply $default$initialQuantity() {
        return TokenInitialSupply.fromNumber(BigInteger.ONE);
    }

    @Generated
    private static Hash $default$hash() {
        return Hash.empty();
    }

    @Generated
    private static GasLimit $default$gasLimit() {
        return GasLimit.defaultNftCreate();
    }

    @Generated
    NFTCreation(@NonNull TokenIdentifier tokenIdentifier, TokenInitialSupply initialQuantity, @NonNull TokenName nftName, @NonNull TokenRoyalties tokenRoyalties, @NonNull Hash hash, @NonNull TokenAttributes tokenAttributes, @NonNull Set<ESDTUri> uris, @NonNull GasLimit gasLimit) {
        if (tokenIdentifier == null) {
            throw new NullPointerException("tokenIdentifier is marked non-null but is null");
        }
        if (nftName == null) {
            throw new NullPointerException("nftName is marked non-null but is null");
        }
        if (tokenRoyalties == null) {
            throw new NullPointerException("tokenRoyalties is marked non-null but is null");
        }
        if (hash == null) {
            throw new NullPointerException("hash is marked non-null but is null");
        }
        if (tokenAttributes == null) {
            throw new NullPointerException("tokenAttributes is marked non-null but is null");
        }
        if (uris == null) {
            throw new NullPointerException("uris is marked non-null but is null");
        }
        if (gasLimit == null) {
            throw new NullPointerException("gasLimit is marked non-null but is null");
        }
        this.tokenIdentifier = tokenIdentifier;
        this.initialQuantity = initialQuantity;
        this.nftName = nftName;
        this.tokenRoyalties = tokenRoyalties;
        this.hash = hash;
        this.tokenAttributes = tokenAttributes;
        this.uris = uris;
        this.gasLimit = gasLimit;
    }

    @Generated
    public static NFTCreationBuilder builder() {
        return new NFTCreationBuilder();
    }

    @NonNull
    @Generated
    public TokenIdentifier getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    @Generated
    public TokenInitialSupply getInitialQuantity() {
        return this.initialQuantity;
    }

    @NonNull
    @Generated
    public TokenName getNftName() {
        return this.nftName;
    }

    @NonNull
    @Generated
    public TokenRoyalties getTokenRoyalties() {
        return this.tokenRoyalties;
    }

    @NonNull
    @Generated
    public Hash getHash() {
        return this.hash;
    }

    @NonNull
    @Generated
    public TokenAttributes getTokenAttributes() {
        return this.tokenAttributes;
    }

    @NonNull
    @Generated
    public Set<ESDTUri> getUris() {
        return this.uris;
    }

    @NonNull
    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NFTCreation)) {
            return false;
        }
        NFTCreation other = (NFTCreation)o;
        TokenIdentifier this$tokenIdentifier = this.getTokenIdentifier();
        TokenIdentifier other$tokenIdentifier = other.getTokenIdentifier();
        if (this$tokenIdentifier == null ? other$tokenIdentifier != null : !((Object)this$tokenIdentifier).equals(other$tokenIdentifier)) {
            return false;
        }
        TokenInitialSupply this$initialQuantity = this.getInitialQuantity();
        TokenInitialSupply other$initialQuantity = other.getInitialQuantity();
        if (this$initialQuantity == null ? other$initialQuantity != null : !((Object)this$initialQuantity).equals(other$initialQuantity)) {
            return false;
        }
        TokenName this$nftName = this.getNftName();
        TokenName other$nftName = other.getNftName();
        if (this$nftName == null ? other$nftName != null : !((Object)this$nftName).equals(other$nftName)) {
            return false;
        }
        TokenRoyalties this$tokenRoyalties = this.getTokenRoyalties();
        TokenRoyalties other$tokenRoyalties = other.getTokenRoyalties();
        if (this$tokenRoyalties == null ? other$tokenRoyalties != null : !((Object)this$tokenRoyalties).equals(other$tokenRoyalties)) {
            return false;
        }
        Hash this$hash = this.getHash();
        Hash other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !((Object)this$hash).equals(other$hash)) {
            return false;
        }
        TokenAttributes this$tokenAttributes = this.getTokenAttributes();
        TokenAttributes other$tokenAttributes = other.getTokenAttributes();
        if (this$tokenAttributes == null ? other$tokenAttributes != null : !((Object)this$tokenAttributes).equals(other$tokenAttributes)) {
            return false;
        }
        Set<ESDTUri> this$uris = this.getUris();
        Set<ESDTUri> other$uris = other.getUris();
        if (this$uris == null ? other$uris != null : !((Object)this$uris).equals(other$uris)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        return !(this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TokenIdentifier $tokenIdentifier = this.getTokenIdentifier();
        result = result * 59 + ($tokenIdentifier == null ? 43 : ((Object)$tokenIdentifier).hashCode());
        TokenInitialSupply $initialQuantity = this.getInitialQuantity();
        result = result * 59 + ($initialQuantity == null ? 43 : ((Object)$initialQuantity).hashCode());
        TokenName $nftName = this.getNftName();
        result = result * 59 + ($nftName == null ? 43 : ((Object)$nftName).hashCode());
        TokenRoyalties $tokenRoyalties = this.getTokenRoyalties();
        result = result * 59 + ($tokenRoyalties == null ? 43 : ((Object)$tokenRoyalties).hashCode());
        Hash $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : ((Object)$hash).hashCode());
        TokenAttributes $tokenAttributes = this.getTokenAttributes();
        result = result * 59 + ($tokenAttributes == null ? 43 : ((Object)$tokenAttributes).hashCode());
        Set<ESDTUri> $uris = this.getUris();
        result = result * 59 + ($uris == null ? 43 : ((Object)$uris).hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NFTCreation(tokenIdentifier=" + this.getTokenIdentifier() + ", initialQuantity=" + this.getInitialQuantity() + ", nftName=" + this.getNftName() + ", tokenRoyalties=" + this.getTokenRoyalties() + ", hash=" + this.getHash() + ", tokenAttributes=" + this.getTokenAttributes() + ", uris=" + this.getUris() + ", gasLimit=" + this.getGasLimit() + ")";
    }

    @Generated
    public static class NFTCreationBuilder {
        @Generated
        private TokenIdentifier tokenIdentifier;
        @Generated
        private boolean initialQuantity$set;
        @Generated
        private TokenInitialSupply initialQuantity$value;
        @Generated
        private TokenName nftName;
        @Generated
        private TokenRoyalties tokenRoyalties;
        @Generated
        private boolean hash$set;
        @Generated
        private Hash hash$value;
        @Generated
        private TokenAttributes tokenAttributes;
        @Generated
        private Set<ESDTUri> uris;
        @Generated
        private boolean gasLimit$set;
        @Generated
        private GasLimit gasLimit$value;

        @Generated
        NFTCreationBuilder() {
        }

        @Generated
        public NFTCreationBuilder tokenIdentifier(@NonNull TokenIdentifier tokenIdentifier) {
            if (tokenIdentifier == null) {
                throw new NullPointerException("tokenIdentifier is marked non-null but is null");
            }
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        @Generated
        public NFTCreationBuilder initialQuantity(TokenInitialSupply initialQuantity) {
            this.initialQuantity$value = initialQuantity;
            this.initialQuantity$set = true;
            return this;
        }

        @Generated
        public NFTCreationBuilder nftName(@NonNull TokenName nftName) {
            if (nftName == null) {
                throw new NullPointerException("nftName is marked non-null but is null");
            }
            this.nftName = nftName;
            return this;
        }

        @Generated
        public NFTCreationBuilder tokenRoyalties(@NonNull TokenRoyalties tokenRoyalties) {
            if (tokenRoyalties == null) {
                throw new NullPointerException("tokenRoyalties is marked non-null but is null");
            }
            this.tokenRoyalties = tokenRoyalties;
            return this;
        }

        @Generated
        public NFTCreationBuilder hash(@NonNull Hash hash) {
            if (hash == null) {
                throw new NullPointerException("hash is marked non-null but is null");
            }
            this.hash$value = hash;
            this.hash$set = true;
            return this;
        }

        @Generated
        public NFTCreationBuilder tokenAttributes(@NonNull TokenAttributes tokenAttributes) {
            if (tokenAttributes == null) {
                throw new NullPointerException("tokenAttributes is marked non-null but is null");
            }
            this.tokenAttributes = tokenAttributes;
            return this;
        }

        @Generated
        public NFTCreationBuilder uris(@NonNull Set<ESDTUri> uris) {
            if (uris == null) {
                throw new NullPointerException("uris is marked non-null but is null");
            }
            this.uris = uris;
            return this;
        }

        @Generated
        public NFTCreationBuilder gasLimit(@NonNull GasLimit gasLimit) {
            if (gasLimit == null) {
                throw new NullPointerException("gasLimit is marked non-null but is null");
            }
            this.gasLimit$value = gasLimit;
            this.gasLimit$set = true;
            return this;
        }

        @Generated
        public NFTCreation build() {
            TokenInitialSupply initialQuantity$value = this.initialQuantity$value;
            if (!this.initialQuantity$set) {
                initialQuantity$value = NFTCreation.$default$initialQuantity();
            }
            Hash hash$value = this.hash$value;
            if (!this.hash$set) {
                hash$value = NFTCreation.$default$hash();
            }
            GasLimit gasLimit$value = this.gasLimit$value;
            if (!this.gasLimit$set) {
                gasLimit$value = NFTCreation.$default$gasLimit();
            }
            return new NFTCreation(this.tokenIdentifier, initialQuantity$value, this.nftName, this.tokenRoyalties, hash$value, this.tokenAttributes, this.uris, gasLimit$value);
        }

        @Generated
        public String toString() {
            return "NFTCreation.NFTCreationBuilder(tokenIdentifier=" + this.tokenIdentifier + ", initialQuantity$value=" + this.initialQuantity$value + ", nftName=" + this.nftName + ", tokenRoyalties=" + this.tokenRoyalties + ", hash$value=" + this.hash$value + ", tokenAttributes=" + this.tokenAttributes + ", uris=" + this.uris + ", gasLimit$value=" + this.gasLimit$value + ")";
        }
    }
}

