/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt;

import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.common.Nonce;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.ESDTTransaction;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenAttributes;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenIdentifier;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.TransactionRequest;

public final class NFTAttributesUpdate
implements ESDTTransaction {
    @NonNull
    private final TokenIdentifier tokenIdentifier;
    @NonNull
    private final Nonce nonce;
    @NonNull
    private final TokenAttributes tokenAttributes;
    @NonNull
    private final GasLimit gasLimit;

    private PayloadData processPayloadData() {
        return PayloadData.fromString(String.format("%s@%s@%s@%s", "ESDTNFTUpdateAttributes", this.tokenIdentifier.getHex(), this.nonce.getHex(), this.tokenAttributes.getHex()));
    }

    @Override
    public TransactionRequest toTransactionRequest(Wallet wallet) {
        return TransactionRequest.builder().receiverAddress(wallet.getAddress()).data(this.processPayloadData()).value(Balance.zero()).gasLimit(this.gasLimit).build();
    }

    @Generated
    private static GasLimit $default$gasLimit() {
        return GasLimit.defaultNftCreate();
    }

    @Generated
    NFTAttributesUpdate(@NonNull TokenIdentifier tokenIdentifier, @NonNull Nonce nonce, @NonNull TokenAttributes tokenAttributes, @NonNull GasLimit gasLimit) {
        if (tokenIdentifier == null) {
            throw new NullPointerException("tokenIdentifier is marked non-null but is null");
        }
        if (nonce == null) {
            throw new NullPointerException("nonce is marked non-null but is null");
        }
        if (tokenAttributes == null) {
            throw new NullPointerException("tokenAttributes is marked non-null but is null");
        }
        if (gasLimit == null) {
            throw new NullPointerException("gasLimit is marked non-null but is null");
        }
        this.tokenIdentifier = tokenIdentifier;
        this.nonce = nonce;
        this.tokenAttributes = tokenAttributes;
        this.gasLimit = gasLimit;
    }

    @Generated
    public static NFTAttributesUpdateBuilder builder() {
        return new NFTAttributesUpdateBuilder();
    }

    @NonNull
    @Generated
    public TokenIdentifier getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    @NonNull
    @Generated
    public Nonce getNonce() {
        return this.nonce;
    }

    @NonNull
    @Generated
    public TokenAttributes getTokenAttributes() {
        return this.tokenAttributes;
    }

    @NonNull
    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NFTAttributesUpdate)) {
            return false;
        }
        NFTAttributesUpdate other = (NFTAttributesUpdate)o;
        TokenIdentifier this$tokenIdentifier = this.getTokenIdentifier();
        TokenIdentifier other$tokenIdentifier = other.getTokenIdentifier();
        if (this$tokenIdentifier == null ? other$tokenIdentifier != null : !((Object)this$tokenIdentifier).equals(other$tokenIdentifier)) {
            return false;
        }
        Nonce this$nonce = this.getNonce();
        Nonce other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
            return false;
        }
        TokenAttributes this$tokenAttributes = this.getTokenAttributes();
        TokenAttributes other$tokenAttributes = other.getTokenAttributes();
        if (this$tokenAttributes == null ? other$tokenAttributes != null : !((Object)this$tokenAttributes).equals(other$tokenAttributes)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        return !(this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TokenIdentifier $tokenIdentifier = this.getTokenIdentifier();
        result = result * 59 + ($tokenIdentifier == null ? 43 : ((Object)$tokenIdentifier).hashCode());
        Nonce $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
        TokenAttributes $tokenAttributes = this.getTokenAttributes();
        result = result * 59 + ($tokenAttributes == null ? 43 : ((Object)$tokenAttributes).hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NFTAttributesUpdate(tokenIdentifier=" + this.getTokenIdentifier() + ", nonce=" + this.getNonce() + ", tokenAttributes=" + this.getTokenAttributes() + ", gasLimit=" + this.getGasLimit() + ")";
    }

    @Generated
    public static class NFTAttributesUpdateBuilder {
        @Generated
        private TokenIdentifier tokenIdentifier;
        @Generated
        private Nonce nonce;
        @Generated
        private TokenAttributes tokenAttributes;
        @Generated
        private boolean gasLimit$set;
        @Generated
        private GasLimit gasLimit$value;

        @Generated
        NFTAttributesUpdateBuilder() {
        }

        @Generated
        public NFTAttributesUpdateBuilder tokenIdentifier(@NonNull TokenIdentifier tokenIdentifier) {
            if (tokenIdentifier == null) {
                throw new NullPointerException("tokenIdentifier is marked non-null but is null");
            }
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        @Generated
        public NFTAttributesUpdateBuilder nonce(@NonNull Nonce nonce) {
            if (nonce == null) {
                throw new NullPointerException("nonce is marked non-null but is null");
            }
            this.nonce = nonce;
            return this;
        }

        @Generated
        public NFTAttributesUpdateBuilder tokenAttributes(@NonNull TokenAttributes tokenAttributes) {
            if (tokenAttributes == null) {
                throw new NullPointerException("tokenAttributes is marked non-null but is null");
            }
            this.tokenAttributes = tokenAttributes;
            return this;
        }

        @Generated
        public NFTAttributesUpdateBuilder gasLimit(@NonNull GasLimit gasLimit) {
            if (gasLimit == null) {
                throw new NullPointerException("gasLimit is marked non-null but is null");
            }
            this.gasLimit$value = gasLimit;
            this.gasLimit$set = true;
            return this;
        }

        @Generated
        public NFTAttributesUpdate build() {
            GasLimit gasLimit$value = this.gasLimit$value;
            if (!this.gasLimit$set) {
                gasLimit$value = NFTAttributesUpdate.$default$gasLimit();
            }
            return new NFTAttributesUpdate(this.tokenIdentifier, this.nonce, this.tokenAttributes, gasLimit$value);
        }

        @Generated
        public String toString() {
            return "NFTAttributesUpdate.NFTAttributesUpdateBuilder(tokenIdentifier=" + this.tokenIdentifier + ", nonce=" + this.nonce + ", tokenAttributes=" + this.tokenAttributes + ", gasLimit$value=" + this.gasLimit$value + ")";
        }
    }
}

