/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.ESDTTransaction;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenIdentifier;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenProperty;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.error.ErrorMessage;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.TransactionRequest;

public final class ESDTUpgrade
implements ESDTTransaction {
    @NonNull
    private final TokenIdentifier tokenIdentifier;
    private final GasLimit gasLimit;
    private final Set<TokenProperty> properties;

    private PayloadData processPayloadData() {
        if (this.properties.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessage.TOKEN_PROPERTY.getValue());
        }
        return PayloadData.fromString(String.format("%s@%s%s", "controlChanges", this.tokenIdentifier.getHex(), this.properties.stream().map(p -> "@" + p.getNameHex() + "@" + p.getValueHex()).collect(Collectors.joining())));
    }

    @Override
    public TransactionRequest toTransactionRequest(Wallet wallet) {
        return TransactionRequest.builder().receiverAddress(Address.fromBech32("erd1qqqqqqqqqqqqqqqpqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqzllls8a5w6u")).data(this.processPayloadData()).value(Balance.zero()).gasLimit(this.gasLimit).build();
    }

    @Generated
    private static GasLimit $default$gasLimit() {
        return GasLimit.defaultEsdtIssuance();
    }

    @Generated
    private static Set<TokenProperty> $default$properties() {
        return new HashSet<TokenProperty>();
    }

    @Generated
    ESDTUpgrade(@NonNull TokenIdentifier tokenIdentifier, GasLimit gasLimit, Set<TokenProperty> properties) {
        if (tokenIdentifier == null) {
            throw new NullPointerException("tokenIdentifier is marked non-null but is null");
        }
        this.tokenIdentifier = tokenIdentifier;
        this.gasLimit = gasLimit;
        this.properties = properties;
    }

    @Generated
    public static ESDTUpgradeBuilder builder() {
        return new ESDTUpgradeBuilder();
    }

    @NonNull
    @Generated
    public TokenIdentifier getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public Set<TokenProperty> getProperties() {
        return this.properties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ESDTUpgrade)) {
            return false;
        }
        ESDTUpgrade other = (ESDTUpgrade)o;
        TokenIdentifier this$tokenIdentifier = this.getTokenIdentifier();
        TokenIdentifier other$tokenIdentifier = other.getTokenIdentifier();
        if (this$tokenIdentifier == null ? other$tokenIdentifier != null : !((Object)this$tokenIdentifier).equals(other$tokenIdentifier)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        if (this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit)) {
            return false;
        }
        Set<TokenProperty> this$properties = this.getProperties();
        Set<TokenProperty> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TokenIdentifier $tokenIdentifier = this.getTokenIdentifier();
        result = result * 59 + ($tokenIdentifier == null ? 43 : ((Object)$tokenIdentifier).hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        Set<TokenProperty> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ESDTUpgrade(tokenIdentifier=" + this.getTokenIdentifier() + ", gasLimit=" + this.getGasLimit() + ", properties=" + this.getProperties() + ")";
    }

    @Generated
    public static class ESDTUpgradeBuilder {
        @Generated
        private TokenIdentifier tokenIdentifier;
        @Generated
        private boolean gasLimit$set;
        @Generated
        private GasLimit gasLimit$value;
        @Generated
        private boolean properties$set;
        @Generated
        private Set<TokenProperty> properties$value;

        @Generated
        ESDTUpgradeBuilder() {
        }

        @Generated
        public ESDTUpgradeBuilder tokenIdentifier(@NonNull TokenIdentifier tokenIdentifier) {
            if (tokenIdentifier == null) {
                throw new NullPointerException("tokenIdentifier is marked non-null but is null");
            }
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        @Generated
        public ESDTUpgradeBuilder gasLimit(GasLimit gasLimit) {
            this.gasLimit$value = gasLimit;
            this.gasLimit$set = true;
            return this;
        }

        @Generated
        public ESDTUpgradeBuilder properties(Set<TokenProperty> properties) {
            this.properties$value = properties;
            this.properties$set = true;
            return this;
        }

        @Generated
        public ESDTUpgrade build() {
            GasLimit gasLimit$value = this.gasLimit$value;
            if (!this.gasLimit$set) {
                gasLimit$value = ESDTUpgrade.$default$gasLimit();
            }
            Set<TokenProperty> properties$value = this.properties$value;
            if (!this.properties$set) {
                properties$value = ESDTUpgrade.$default$properties();
            }
            return new ESDTUpgrade(this.tokenIdentifier, gasLimit$value, properties$value);
        }

        @Generated
        public String toString() {
            return "ESDTUpgrade.ESDTUpgradeBuilder(tokenIdentifier=" + this.tokenIdentifier + ", gasLimit$value=" + this.gasLimit$value + ", properties$value=" + this.properties$value + ")";
        }
    }
}

