/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt;

import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.ESDTTransaction;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenIdentifier;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.TransactionRequest;

public final class ESDTLocalOp
implements ESDTTransaction {
    @NonNull
    private final Type type;
    @NonNull
    private final TokenIdentifier tokenIdentifier;
    @NonNull
    private final Balance amount;
    @NonNull
    private final GasLimit gasLimit;

    private PayloadData processPayloadData() {
        return PayloadData.fromString(String.format("%s@%s@%s", this.processType(), this.tokenIdentifier.getHex(), this.amount.getHex()));
    }

    @Override
    public TransactionRequest toTransactionRequest(Wallet wallet) {
        return TransactionRequest.builder().receiverAddress(wallet.getAddress()).data(this.processPayloadData()).value(Balance.zero()).gasLimit(this.gasLimit).build();
    }

    private String processType() {
        return this.type.equals((Object)Type.MINT) ? "ESDTLocalMint" : "ESDTLocalBurn";
    }

    @Generated
    private static GasLimit $default$gasLimit() {
        return GasLimit.defaultEsdtLocalOp();
    }

    @Generated
    ESDTLocalOp(@NonNull Type type, @NonNull TokenIdentifier tokenIdentifier, @NonNull Balance amount, @NonNull GasLimit gasLimit) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (tokenIdentifier == null) {
            throw new NullPointerException("tokenIdentifier is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (gasLimit == null) {
            throw new NullPointerException("gasLimit is marked non-null but is null");
        }
        this.type = type;
        this.tokenIdentifier = tokenIdentifier;
        this.amount = amount;
        this.gasLimit = gasLimit;
    }

    @Generated
    public static ESDTLocalOpBuilder builder() {
        return new ESDTLocalOpBuilder();
    }

    @NonNull
    @Generated
    public Type getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public TokenIdentifier getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    @NonNull
    @Generated
    public Balance getAmount() {
        return this.amount;
    }

    @NonNull
    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ESDTLocalOp)) {
            return false;
        }
        ESDTLocalOp other = (ESDTLocalOp)o;
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        TokenIdentifier this$tokenIdentifier = this.getTokenIdentifier();
        TokenIdentifier other$tokenIdentifier = other.getTokenIdentifier();
        if (this$tokenIdentifier == null ? other$tokenIdentifier != null : !((Object)this$tokenIdentifier).equals(other$tokenIdentifier)) {
            return false;
        }
        Balance this$amount = this.getAmount();
        Balance other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        return !(this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        TokenIdentifier $tokenIdentifier = this.getTokenIdentifier();
        result = result * 59 + ($tokenIdentifier == null ? 43 : ((Object)$tokenIdentifier).hashCode());
        Balance $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ESDTLocalOp(type=" + this.getType() + ", tokenIdentifier=" + this.getTokenIdentifier() + ", amount=" + this.getAmount() + ", gasLimit=" + this.getGasLimit() + ")";
    }

    @Generated
    public static class ESDTLocalOpBuilder {
        @Generated
        private Type type;
        @Generated
        private TokenIdentifier tokenIdentifier;
        @Generated
        private Balance amount;
        @Generated
        private boolean gasLimit$set;
        @Generated
        private GasLimit gasLimit$value;

        @Generated
        ESDTLocalOpBuilder() {
        }

        @Generated
        public ESDTLocalOpBuilder type(@NonNull Type type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @Generated
        public ESDTLocalOpBuilder tokenIdentifier(@NonNull TokenIdentifier tokenIdentifier) {
            if (tokenIdentifier == null) {
                throw new NullPointerException("tokenIdentifier is marked non-null but is null");
            }
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        @Generated
        public ESDTLocalOpBuilder amount(@NonNull Balance amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = amount;
            return this;
        }

        @Generated
        public ESDTLocalOpBuilder gasLimit(@NonNull GasLimit gasLimit) {
            if (gasLimit == null) {
                throw new NullPointerException("gasLimit is marked non-null but is null");
            }
            this.gasLimit$value = gasLimit;
            this.gasLimit$set = true;
            return this;
        }

        @Generated
        public ESDTLocalOp build() {
            GasLimit gasLimit$value = this.gasLimit$value;
            if (!this.gasLimit$set) {
                gasLimit$value = ESDTLocalOp.$default$gasLimit();
            }
            return new ESDTLocalOp(this.type, this.tokenIdentifier, this.amount, gasLimit$value);
        }

        @Generated
        public String toString() {
            return "ESDTLocalOp.ESDTLocalOpBuilder(type=" + this.type + ", tokenIdentifier=" + this.tokenIdentifier + ", amount=" + this.amount + ", gasLimit$value=" + this.gasLimit$value + ")";
        }
    }

    public static enum Type {
        MINT,
        BURN;

    }
}

