/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import lombok.Generated;
import software.crldev.elrondspringbootstarterreactive.config.constants.CurrencyConstants;
import software.crldev.elrondspringbootstarterreactive.error.exception.InvalidBalanceException;
import software.crldev.elrondspringbootstarterreactive.util.HexValidator;

public final class Balance {
    private final BigInteger value;

    private Balance(String value) {
        BigInteger bigIntValue = new BigInteger(value);
        if (bigIntValue.signum() == -1) {
            throw new InvalidBalanceException(bigIntValue);
        }
        this.value = bigIntValue;
    }

    public static Balance fromEgld(Double value) {
        String oneEgldString = CurrencyConstants.ONE_EGLD_STRING;
        BigDecimal bigDecimalGold = new BigDecimal(String.valueOf(value));
        int unit = bigDecimalGold.intValue();
        String decimals = bigDecimalGold.subtract(new BigDecimal(unit)).toPlainString().split("\\.")[1];
        String bigIntUnits = new BigInteger(unit + decimals).multiply(new BigInteger(oneEgldString.substring(0, oneEgldString.length() - decimals.length()))).toString();
        return new Balance(bigIntUnits);
    }

    public String getHex() {
        return HexValidator.processNumberHexArgument(this.value.toString(16));
    }

    public static Balance fromString(String value) {
        return new Balance(value);
    }

    public static Balance fromNumber(BigInteger value) {
        return new Balance(value.toString());
    }

    public static Balance zero() {
        return new Balance("0");
    }

    public boolean isZero() {
        return this.value.signum() == 0;
    }

    public boolean isSet() {
        return this.value.signum() != 0;
    }

    public String toCurrencyString() {
        BigInteger[] currencyValues = this.value.divideAndRemainder(new BigInteger(CurrencyConstants.ONE_EGLD_STRING));
        String number = currencyValues[0].toString();
        String decimals = currencyValues[1].toString();
        String decimalsToDisplay = decimals.equals("0") ? decimals.concat("0") : currencyValues[1].toString().substring(0, 2);
        return String.format("%s.%s%s", number, decimalsToDisplay, "EGLD");
    }

    public String toString() {
        return this.value.toString(CurrencyConstants.BASE10);
    }

    @Generated
    public BigInteger getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Balance)) {
            return false;
        }
        Balance other = (Balance)o;
        BigInteger this$value = this.getValue();
        BigInteger other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

