/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import software.crldev.elrondspringbootstarterreactive.api.ApiResponse;
import software.crldev.elrondspringbootstarterreactive.error.exception.DeserializationException;

public class JsonMapper {
    private static final ObjectMapper mapper = new Jackson2ObjectMapperBuilder().build().setDefaultPropertyInclusion(JsonInclude.Include.NON_EMPTY);

    private JsonMapper() {
    }

    public static <T> ApiResponse<T> deserializeApiResponse(String response, Class<T> responseType) {
        try {
            JavaType type = mapper.getTypeFactory().constructParametricType(ApiResponse.class, new Class[]{responseType});
            return (ApiResponse)mapper.readValue(response, type);
        }
        catch (JsonProcessingException e) {
            throw new DeserializationException(e.getMessage());
        }
    }

    public static byte[] serializeToJsonBuffer(Object object) throws JsonProcessingException {
        return mapper.writeValueAsString(object).getBytes();
    }
}

