/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonDeserialize(builder=ShardStatusBuilder.class)
public final class ShardStatus {
    @JsonProperty(value="erd_current_round")
    private final long currentRound;
    @JsonProperty(value="erd_epoch_number")
    private final long epochNumber;
    @JsonProperty(value="erd_highest_final_nonce")
    private final long highestFinalNonce;
    @JsonProperty(value="erd_nonce")
    private final long nonce;
    @JsonProperty(value="erd_nonce_at_epoch_start")
    private final long nonceAtEpochStart;
    @JsonProperty(value="erd_nonces_passed_in_current_epoch")
    private final long noncesPassedInCurrentEpoch;
    @JsonProperty(value="erd_round_at_epoch_start")
    private final long roundAtEpochStart;
    @JsonProperty(value="erd_rounds_passed_in_current_epoch")
    private final long roundsPassedInCurrentEpoch;
    @JsonProperty(value="erd_rounds_per_epoch")
    private final long roundsPerEpoch;

    @Generated
    ShardStatus(long currentRound, long epochNumber, long highestFinalNonce, long nonce, long nonceAtEpochStart, long noncesPassedInCurrentEpoch, long roundAtEpochStart, long roundsPassedInCurrentEpoch, long roundsPerEpoch) {
        this.currentRound = currentRound;
        this.epochNumber = epochNumber;
        this.highestFinalNonce = highestFinalNonce;
        this.nonce = nonce;
        this.nonceAtEpochStart = nonceAtEpochStart;
        this.noncesPassedInCurrentEpoch = noncesPassedInCurrentEpoch;
        this.roundAtEpochStart = roundAtEpochStart;
        this.roundsPassedInCurrentEpoch = roundsPassedInCurrentEpoch;
        this.roundsPerEpoch = roundsPerEpoch;
    }

    @Generated
    public static ShardStatusBuilder builder() {
        return new ShardStatusBuilder();
    }

    @Generated
    public long getCurrentRound() {
        return this.currentRound;
    }

    @Generated
    public long getEpochNumber() {
        return this.epochNumber;
    }

    @Generated
    public long getHighestFinalNonce() {
        return this.highestFinalNonce;
    }

    @Generated
    public long getNonce() {
        return this.nonce;
    }

    @Generated
    public long getNonceAtEpochStart() {
        return this.nonceAtEpochStart;
    }

    @Generated
    public long getNoncesPassedInCurrentEpoch() {
        return this.noncesPassedInCurrentEpoch;
    }

    @Generated
    public long getRoundAtEpochStart() {
        return this.roundAtEpochStart;
    }

    @Generated
    public long getRoundsPassedInCurrentEpoch() {
        return this.roundsPassedInCurrentEpoch;
    }

    @Generated
    public long getRoundsPerEpoch() {
        return this.roundsPerEpoch;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardStatus)) {
            return false;
        }
        ShardStatus other = (ShardStatus)o;
        if (this.getCurrentRound() != other.getCurrentRound()) {
            return false;
        }
        if (this.getEpochNumber() != other.getEpochNumber()) {
            return false;
        }
        if (this.getHighestFinalNonce() != other.getHighestFinalNonce()) {
            return false;
        }
        if (this.getNonce() != other.getNonce()) {
            return false;
        }
        if (this.getNonceAtEpochStart() != other.getNonceAtEpochStart()) {
            return false;
        }
        if (this.getNoncesPassedInCurrentEpoch() != other.getNoncesPassedInCurrentEpoch()) {
            return false;
        }
        if (this.getRoundAtEpochStart() != other.getRoundAtEpochStart()) {
            return false;
        }
        if (this.getRoundsPassedInCurrentEpoch() != other.getRoundsPassedInCurrentEpoch()) {
            return false;
        }
        return this.getRoundsPerEpoch() == other.getRoundsPerEpoch();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $currentRound = this.getCurrentRound();
        result = result * 59 + (int)($currentRound >>> 32 ^ $currentRound);
        long $epochNumber = this.getEpochNumber();
        result = result * 59 + (int)($epochNumber >>> 32 ^ $epochNumber);
        long $highestFinalNonce = this.getHighestFinalNonce();
        result = result * 59 + (int)($highestFinalNonce >>> 32 ^ $highestFinalNonce);
        long $nonce = this.getNonce();
        result = result * 59 + (int)($nonce >>> 32 ^ $nonce);
        long $nonceAtEpochStart = this.getNonceAtEpochStart();
        result = result * 59 + (int)($nonceAtEpochStart >>> 32 ^ $nonceAtEpochStart);
        long $noncesPassedInCurrentEpoch = this.getNoncesPassedInCurrentEpoch();
        result = result * 59 + (int)($noncesPassedInCurrentEpoch >>> 32 ^ $noncesPassedInCurrentEpoch);
        long $roundAtEpochStart = this.getRoundAtEpochStart();
        result = result * 59 + (int)($roundAtEpochStart >>> 32 ^ $roundAtEpochStart);
        long $roundsPassedInCurrentEpoch = this.getRoundsPassedInCurrentEpoch();
        result = result * 59 + (int)($roundsPassedInCurrentEpoch >>> 32 ^ $roundsPassedInCurrentEpoch);
        long $roundsPerEpoch = this.getRoundsPerEpoch();
        result = result * 59 + (int)($roundsPerEpoch >>> 32 ^ $roundsPerEpoch);
        return result;
    }

    @Generated
    public String toString() {
        return "ShardStatus(currentRound=" + this.getCurrentRound() + ", epochNumber=" + this.getEpochNumber() + ", highestFinalNonce=" + this.getHighestFinalNonce() + ", nonce=" + this.getNonce() + ", nonceAtEpochStart=" + this.getNonceAtEpochStart() + ", noncesPassedInCurrentEpoch=" + this.getNoncesPassedInCurrentEpoch() + ", roundAtEpochStart=" + this.getRoundAtEpochStart() + ", roundsPassedInCurrentEpoch=" + this.getRoundsPassedInCurrentEpoch() + ", roundsPerEpoch=" + this.getRoundsPerEpoch() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class ShardStatusBuilder {
        @Generated
        private long currentRound;
        @Generated
        private long epochNumber;
        @Generated
        private long highestFinalNonce;
        @Generated
        private long nonce;
        @Generated
        private long nonceAtEpochStart;
        @Generated
        private long noncesPassedInCurrentEpoch;
        @Generated
        private long roundAtEpochStart;
        @Generated
        private long roundsPassedInCurrentEpoch;
        @Generated
        private long roundsPerEpoch;

        @Generated
        ShardStatusBuilder() {
        }

        @JsonProperty(value="erd_current_round")
        @Generated
        public ShardStatusBuilder currentRound(long currentRound) {
            this.currentRound = currentRound;
            return this;
        }

        @JsonProperty(value="erd_epoch_number")
        @Generated
        public ShardStatusBuilder epochNumber(long epochNumber) {
            this.epochNumber = epochNumber;
            return this;
        }

        @JsonProperty(value="erd_highest_final_nonce")
        @Generated
        public ShardStatusBuilder highestFinalNonce(long highestFinalNonce) {
            this.highestFinalNonce = highestFinalNonce;
            return this;
        }

        @JsonProperty(value="erd_nonce")
        @Generated
        public ShardStatusBuilder nonce(long nonce) {
            this.nonce = nonce;
            return this;
        }

        @JsonProperty(value="erd_nonce_at_epoch_start")
        @Generated
        public ShardStatusBuilder nonceAtEpochStart(long nonceAtEpochStart) {
            this.nonceAtEpochStart = nonceAtEpochStart;
            return this;
        }

        @JsonProperty(value="erd_nonces_passed_in_current_epoch")
        @Generated
        public ShardStatusBuilder noncesPassedInCurrentEpoch(long noncesPassedInCurrentEpoch) {
            this.noncesPassedInCurrentEpoch = noncesPassedInCurrentEpoch;
            return this;
        }

        @JsonProperty(value="erd_round_at_epoch_start")
        @Generated
        public ShardStatusBuilder roundAtEpochStart(long roundAtEpochStart) {
            this.roundAtEpochStart = roundAtEpochStart;
            return this;
        }

        @JsonProperty(value="erd_rounds_passed_in_current_epoch")
        @Generated
        public ShardStatusBuilder roundsPassedInCurrentEpoch(long roundsPassedInCurrentEpoch) {
            this.roundsPassedInCurrentEpoch = roundsPassedInCurrentEpoch;
            return this;
        }

        @JsonProperty(value="erd_rounds_per_epoch")
        @Generated
        public ShardStatusBuilder roundsPerEpoch(long roundsPerEpoch) {
            this.roundsPerEpoch = roundsPerEpoch;
            return this;
        }

        @Generated
        public ShardStatus build() {
            return new ShardStatus(this.currentRound, this.epochNumber, this.highestFinalNonce, this.nonce, this.nonceAtEpochStart, this.noncesPassedInCurrentEpoch, this.roundAtEpochStart, this.roundsPassedInCurrentEpoch, this.roundsPerEpoch);
        }

        @Generated
        public String toString() {
            return "ShardStatus.ShardStatusBuilder(currentRound=" + this.currentRound + ", epochNumber=" + this.epochNumber + ", highestFinalNonce=" + this.highestFinalNonce + ", nonce=" + this.nonce + ", nonceAtEpochStart=" + this.nonceAtEpochStart + ", noncesPassedInCurrentEpoch=" + this.noncesPassedInCurrentEpoch + ", roundAtEpochStart=" + this.roundAtEpochStart + ", roundsPassedInCurrentEpoch=" + this.roundsPassedInCurrentEpoch + ", roundsPerEpoch=" + this.roundsPerEpoch + ")";
        }
    }
}

