/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.transaction;

import java.math.BigInteger;
import lombok.Generated;
import software.crldev.elrondspringbootstarterreactive.config.constants.CurrencyConstants;
import software.crldev.elrondspringbootstarterreactive.config.constants.ESDTConstants;
import software.crldev.elrondspringbootstarterreactive.config.constants.TransactionConstants;
import software.crldev.elrondspringbootstarterreactive.error.exception.NegativeGasException;

public final class GasLimit {
    private final BigInteger value;

    private GasLimit(BigInteger value) {
        if (value.signum() == -1) {
            throw new NegativeGasException(value);
        }
        this.value = value;
    }

    public static GasLimit fromNumber(BigInteger value) {
        return new GasLimit(value);
    }

    public static GasLimit fromString(String value) {
        return GasLimit.fromNumber(new BigInteger(value));
    }

    public static GasLimit zero() {
        return new GasLimit(BigInteger.ZERO);
    }

    public boolean isZero() {
        return this.value.signum() == 0;
    }

    public static GasLimit defaultSmartContractCall() {
        return GasLimit.fromNumber(TransactionConstants.SC_CALL_GAS_LIMIT);
    }

    public static GasLimit defaultEsdtTransfer() {
        return GasLimit.fromNumber(ESDTConstants.ESDT_TRANSFER_GAS_COST);
    }

    public static GasLimit multiEsdtTransfer(int numOfTokens) {
        return GasLimit.fromNumber(ESDTConstants.ESDT_MULTI_TRANSFER_GAS_COST_BASE.multiply(BigInteger.valueOf(numOfTokens)));
    }

    public static GasLimit defaultEsdtIssuance() {
        return GasLimit.fromNumber(ESDTConstants.ESDT_ISSUANCE_GAS_COST);
    }

    public static GasLimit defaultNftCreate() {
        return GasLimit.fromNumber(ESDTConstants.ESDT_NFT_CREATE_COST);
    }

    public static GasLimit defaultEsdtLocalOp() {
        return GasLimit.fromNumber(ESDTConstants.ESDT_LOCAL_OP_GAS_COST);
    }

    public static GasLimit defaultEsdtGlobalOp() {
        return GasLimit.fromNumber(ESDTConstants.ESDT_GLOBAL_OP_GAS_COST);
    }

    public String toString() {
        return this.value.toString(CurrencyConstants.BASE10);
    }

    @Generated
    public BigInteger getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GasLimit)) {
            return false;
        }
        GasLimit other = (GasLimit)o;
        BigInteger this$value = this.getValue();
        BigInteger other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

