/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.smartcontract;

import io.netty.util.internal.StringUtil;
import java.math.BigInteger;
import java.util.Objects;
import lombok.Generated;
import org.bouncycastle.util.encoders.Hex;
import software.crldev.elrondspringbootstarterreactive.error.ErrorMessage;
import software.crldev.elrondspringbootstarterreactive.util.HexValidator;

public final class FunctionArg {
    private final String sVal;
    private final BigInteger nVal;

    private FunctionArg(String sVal, BigInteger nVal) {
        this.sVal = sVal;
        this.nVal = nVal;
    }

    public static FunctionArg fromString(String arg) {
        if (StringUtil.isNullOrEmpty((String)arg)) {
            throw new IllegalArgumentException(ErrorMessage.FUNCTION_ARG_NULL.getValue());
        }
        return new FunctionArg(arg.replaceAll("\\s+", ""), null);
    }

    public static FunctionArg fromNumber(BigInteger arg) {
        if (!Objects.nonNull(arg) || arg.signum() == -1) {
            throw new IllegalArgumentException(ErrorMessage.FUNCTION_ARG_NULL.getValue());
        }
        return new FunctionArg(null, arg);
    }

    public String getHex() {
        return Objects.nonNull(this.sVal) ? Hex.toHexString((byte[])this.sVal.getBytes()) : HexValidator.processNumberHexArgument(this.nVal.toString(16));
    }

    public String toString() {
        return Objects.nonNull(this.sVal) ? this.sVal : this.nVal.toString();
    }

    @Generated
    public String getSVal() {
        return this.sVal;
    }

    @Generated
    public BigInteger getNVal() {
        return this.nVal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionArg)) {
            return false;
        }
        FunctionArg other = (FunctionArg)o;
        String this$sVal = this.getSVal();
        String other$sVal = other.getSVal();
        if (this$sVal == null ? other$sVal != null : !this$sVal.equals(other$sVal)) {
            return false;
        }
        BigInteger this$nVal = this.getNVal();
        BigInteger other$nVal = other.getNVal();
        return !(this$nVal == null ? other$nVal != null : !((Object)this$nVal).equals(other$nVal));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $sVal = this.getSVal();
        result = result * 59 + ($sVal == null ? 43 : $sVal.hashCode());
        BigInteger $nVal = this.getNVal();
        result = result * 59 + ($nVal == null ? 43 : ((Object)$nVal).hashCode());
        return result;
    }
}

