/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.smartcontract;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.smartcontract.FunctionArg;
import software.crldev.elrondspringbootstarterreactive.domain.smartcontract.FunctionName;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;

public final class ContractFunction {
    @NonNull
    private final Address smartContractAddress;
    @NonNull
    private final FunctionName functionName;
    @NonNull
    private final List<FunctionArg> args;
    @NonNull
    private final Balance value;
    @NonNull
    private final GasLimit gasLimit;

    public PayloadData getPayloadData() {
        return PayloadData.fromString(String.format("%s%s", this.functionName.getValue(), this.args.stream().map(p -> "@" + p.getHex()).collect(Collectors.joining())));
    }

    @Generated
    private static List<FunctionArg> $default$args() {
        return Collections.emptyList();
    }

    @Generated
    private static Balance $default$value() {
        return Balance.zero();
    }

    @Generated
    private static GasLimit $default$gasLimit() {
        return GasLimit.defaultSmartContractCall();
    }

    @Generated
    ContractFunction(@NonNull Address smartContractAddress, @NonNull FunctionName functionName, @NonNull List<FunctionArg> args, @NonNull Balance value, @NonNull GasLimit gasLimit) {
        if (smartContractAddress == null) {
            throw new NullPointerException("smartContractAddress is marked non-null but is null");
        }
        if (functionName == null) {
            throw new NullPointerException("functionName is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (gasLimit == null) {
            throw new NullPointerException("gasLimit is marked non-null but is null");
        }
        this.smartContractAddress = smartContractAddress;
        this.functionName = functionName;
        this.args = args;
        this.value = value;
        this.gasLimit = gasLimit;
    }

    @Generated
    public static ContractFunctionBuilder builder() {
        return new ContractFunctionBuilder();
    }

    @Generated
    public ContractFunctionBuilder toBuilder() {
        return new ContractFunctionBuilder().smartContractAddress(this.smartContractAddress).functionName(this.functionName).args(this.args).value(this.value).gasLimit(this.gasLimit);
    }

    @NonNull
    @Generated
    public Address getSmartContractAddress() {
        return this.smartContractAddress;
    }

    @NonNull
    @Generated
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    @NonNull
    @Generated
    public List<FunctionArg> getArgs() {
        return this.args;
    }

    @NonNull
    @Generated
    public Balance getValue() {
        return this.value;
    }

    @NonNull
    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContractFunction)) {
            return false;
        }
        ContractFunction other = (ContractFunction)o;
        Address this$smartContractAddress = this.getSmartContractAddress();
        Address other$smartContractAddress = other.getSmartContractAddress();
        if (this$smartContractAddress == null ? other$smartContractAddress != null : !this$smartContractAddress.equals(other$smartContractAddress)) {
            return false;
        }
        FunctionName this$functionName = this.getFunctionName();
        FunctionName other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !((Object)this$functionName).equals(other$functionName)) {
            return false;
        }
        List<FunctionArg> this$args = this.getArgs();
        List<FunctionArg> other$args = other.getArgs();
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        Balance this$value = this.getValue();
        Balance other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        return !(this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Address $smartContractAddress = this.getSmartContractAddress();
        result = result * 59 + ($smartContractAddress == null ? 43 : $smartContractAddress.hashCode());
        FunctionName $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : ((Object)$functionName).hashCode());
        List<FunctionArg> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        Balance $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ContractFunction(smartContractAddress=" + this.getSmartContractAddress() + ", functionName=" + this.getFunctionName() + ", args=" + this.getArgs() + ", value=" + this.getValue() + ", gasLimit=" + this.getGasLimit() + ")";
    }

    @Generated
    public static class ContractFunctionBuilder {
        @Generated
        private Address smartContractAddress;
        @Generated
        private FunctionName functionName;
        @Generated
        private boolean args$set;
        @Generated
        private List<FunctionArg> args$value;
        @Generated
        private boolean value$set;
        @Generated
        private Balance value$value;
        @Generated
        private boolean gasLimit$set;
        @Generated
        private GasLimit gasLimit$value;

        @Generated
        ContractFunctionBuilder() {
        }

        @Generated
        public ContractFunctionBuilder smartContractAddress(@NonNull Address smartContractAddress) {
            if (smartContractAddress == null) {
                throw new NullPointerException("smartContractAddress is marked non-null but is null");
            }
            this.smartContractAddress = smartContractAddress;
            return this;
        }

        @Generated
        public ContractFunctionBuilder functionName(@NonNull FunctionName functionName) {
            if (functionName == null) {
                throw new NullPointerException("functionName is marked non-null but is null");
            }
            this.functionName = functionName;
            return this;
        }

        @Generated
        public ContractFunctionBuilder args(@NonNull List<FunctionArg> args) {
            if (args == null) {
                throw new NullPointerException("args is marked non-null but is null");
            }
            this.args$value = args;
            this.args$set = true;
            return this;
        }

        @Generated
        public ContractFunctionBuilder value(@NonNull Balance value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value$value = value;
            this.value$set = true;
            return this;
        }

        @Generated
        public ContractFunctionBuilder gasLimit(@NonNull GasLimit gasLimit) {
            if (gasLimit == null) {
                throw new NullPointerException("gasLimit is marked non-null but is null");
            }
            this.gasLimit$value = gasLimit;
            this.gasLimit$set = true;
            return this;
        }

        @Generated
        public ContractFunction build() {
            List<FunctionArg> args$value = this.args$value;
            if (!this.args$set) {
                args$value = ContractFunction.$default$args();
            }
            Balance value$value = this.value$value;
            if (!this.value$set) {
                value$value = ContractFunction.$default$value();
            }
            GasLimit gasLimit$value = this.gasLimit$value;
            if (!this.gasLimit$set) {
                gasLimit$value = ContractFunction.$default$gasLimit();
            }
            return new ContractFunction(this.smartContractAddress, this.functionName, args$value, value$value, gasLimit$value);
        }

        @Generated
        public String toString() {
            return "ContractFunction.ContractFunctionBuilder(smartContractAddress=" + this.smartContractAddress + ", functionName=" + this.functionName + ", args$value=" + this.args$value + ", value$value=" + this.value$value + ", gasLimit$value=" + this.gasLimit$value + ")";
        }
    }
}

