/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt.common;

import java.util.Objects;
import lombok.Generated;
import software.crldev.elrondspringbootstarterreactive.error.ErrorMessage;
import software.crldev.elrondspringbootstarterreactive.util.HexValidator;

public final class TokenRoyalties {
    private final Integer value;

    private TokenRoyalties(Integer number) {
        this.value = number;
    }

    public static TokenRoyalties fromNumber(Integer value) {
        if (!Objects.nonNull(value) || value < 0 || value > 10000) {
            throw new IllegalArgumentException(ErrorMessage.TOKEN_ROYALTIES.getValue());
        }
        return new TokenRoyalties(value);
    }

    public String getHex() {
        return HexValidator.processNumberHexArgument(Integer.toString(this.value, 16));
    }

    public String toString() {
        return this.value.toString();
    }

    @Generated
    public Integer getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenRoyalties)) {
            return false;
        }
        TokenRoyalties other = (TokenRoyalties)o;
        Integer this$value = this.getValue();
        Integer other$value = other.getValue();
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }
}

