/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt.common;

import io.netty.util.internal.StringUtil;
import lombok.Generated;
import org.bouncycastle.util.encoders.Hex;
import software.crldev.elrondspringbootstarterreactive.error.ErrorMessage;

public final class TokenName {
    private final String value;

    private TokenName(String name) {
        this.value = name;
    }

    public static TokenName fromString(String name) {
        if (StringUtil.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException(ErrorMessage.TOKEN_NAME.getValue());
        }
        String value = name.replaceAll("\\s+", "");
        TokenName.verifyFormat(value);
        return new TokenName(value);
    }

    public String getHex() {
        return Hex.toHexString((byte[])this.value.getBytes());
    }

    public String toString() {
        return this.value;
    }

    private static void verifyFormat(String value) {
        if (!value.matches("^[a-zA-Z0-9]{3,20}+$")) {
            throw new IllegalArgumentException(ErrorMessage.TOKEN_NAME.getValue());
        }
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenName)) {
            return false;
        }
        TokenName other = (TokenName)o;
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

