/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt.common;

import lombok.Generated;
import software.crldev.elrondspringbootstarterreactive.error.ErrorMessage;
import software.crldev.elrondspringbootstarterreactive.util.HexValidator;

public final class TokenDecimals {
    private final Integer decimals;

    private TokenDecimals(Integer decimals) {
        this.decimals = decimals;
    }

    public static TokenDecimals fromNumber(Integer decimals) {
        TokenDecimals.verifyDecimals(decimals);
        return new TokenDecimals(decimals);
    }

    public static TokenDecimals fromString(String decimals) {
        int decimalsNumber = Integer.parseInt(decimals.strip());
        TokenDecimals.verifyDecimals(decimalsNumber);
        return TokenDecimals.fromNumber(decimalsNumber);
    }

    public String getHex() {
        return HexValidator.processNumberHexArgument(Integer.toString(this.decimals, 16));
    }

    public String toString() {
        return this.decimals.toString();
    }

    private static void verifyDecimals(Integer decimals) {
        if (decimals < 0 || decimals > 18 || decimals % 2 != 0) {
            throw new IllegalArgumentException(ErrorMessage.TOKEN_DECIMALS.getValue());
        }
    }

    @Generated
    public Integer getDecimals() {
        return this.decimals;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenDecimals)) {
            return false;
        }
        TokenDecimals other = (TokenDecimals)o;
        Integer this$decimals = this.getDecimals();
        Integer other$decimals = other.getDecimals();
        return !(this$decimals == null ? other$decimals != null : !((Object)this$decimals).equals(other$decimals));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $decimals = this.getDecimals();
        result = result * 59 + ($decimals == null ? 43 : ((Object)$decimals).hashCode());
        return result;
    }
}

