/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt.common;

import io.netty.util.internal.StringUtil;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bouncycastle.util.encoders.Hex;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.ESDTUri;
import software.crldev.elrondspringbootstarterreactive.error.ErrorMessage;

public final class TokenAttributes {
    private final ESDTUri metadataUri;
    private final Set<String> tags;

    private TokenAttributes(ESDTUri metadataUri, Set<String> tags) {
        this.metadataUri = metadataUri;
        this.tags = tags;
    }

    public static TokenAttributes fromString(String metadata, String[] tags) {
        TokenAttributes.verifyNullEmpty(tags);
        Set<String> tagsW = Arrays.stream(tags).map(TokenAttributes::removeWhitespace).collect(Collectors.toSet());
        return new TokenAttributes(ESDTUri.fromString(metadata, ESDTUri.Type.METADATA), tagsW);
    }

    public String getHex() {
        return Hex.toHexString((byte[])this.toString().getBytes());
    }

    public String toString() {
        return "metadata:" + this.metadataUri.getValue() + ";tags:" + String.join((CharSequence)",", this.tags);
    }

    private static String removeWhitespace(String value) {
        return value.replaceAll("\\s+", "");
    }

    private static void verifyNullEmpty(String ... value) {
        if (value == null || value.length == 0) {
            throw new IllegalArgumentException(ErrorMessage.TOKEN_ATTRIBUTES.getValue());
        }
        Arrays.stream(value).forEach(v -> {
            if (StringUtil.isNullOrEmpty((String)v)) {
                throw new IllegalArgumentException(ErrorMessage.TOKEN_ATTRIBUTES.getValue());
            }
        });
    }

    @Generated
    public ESDTUri getMetadataUri() {
        return this.metadataUri;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenAttributes)) {
            return false;
        }
        TokenAttributes other = (TokenAttributes)o;
        ESDTUri this$metadataUri = this.getMetadataUri();
        ESDTUri other$metadataUri = other.getMetadataUri();
        if (this$metadataUri == null ? other$metadataUri != null : !((Object)this$metadataUri).equals(other$metadataUri)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ESDTUri $metadataUri = this.getMetadataUri();
        result = result * 59 + ($metadataUri == null ? 43 : ((Object)$metadataUri).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }
}

