/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt.common;

import io.netty.util.internal.StringUtil;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.web.util.UriUtils;
import software.crldev.elrondspringbootstarterreactive.error.ErrorMessage;

public final class ESDTUri {
    private final String value;

    private ESDTUri(String value) {
        this.value = value;
    }

    public static ESDTUri fromString(String value, Type type) {
        ESDTUri.verifyNullEmpty(value, type);
        String valueW = ESDTUri.removeWhitespace(value);
        try {
            new URI(value);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI syntax.");
        }
        ESDTUri.verifyExtension(UriUtils.extractFileExtension((String)valueW), type);
        return new ESDTUri(valueW);
    }

    public String getHex() {
        return Hex.toHexString((byte[])this.value.getBytes());
    }

    private static void verifyExtension(String extension, Type type) {
        ESDTUri.verifyNullEmpty(extension, type);
        if (type.equals((Object)Type.METADATA)) {
            if (!extension.equalsIgnoreCase("json")) {
                throw new IllegalArgumentException(ErrorMessage.NFT_METADATA_URI.getValue());
            }
        } else {
            switch (extension.toLowerCase()) {
                case "png": 
                case "jpeg": 
                case "jpg": 
                case "gif": 
                case "acc": 
                case "flac": 
                case "m4a": 
                case "mp3": 
                case "wav": 
                case "mov": 
                case "quicktime": 
                case "mp4": 
                case "webm": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(ErrorMessage.NFT_MEDIA_URI.getValue());
                }
            }
        }
    }

    private static String removeWhitespace(String value) {
        return value.replaceAll("\\s+", "");
    }

    private static void verifyNullEmpty(String value, Type type) {
        if (StringUtil.isNullOrEmpty((String)value)) {
            if (type.equals((Object)Type.METADATA)) {
                throw new IllegalArgumentException(ErrorMessage.NFT_METADATA_URI.getValue());
            }
            throw new IllegalArgumentException(ErrorMessage.NFT_MEDIA_URI.getValue());
        }
    }

    @Generated
    public static ESDTUriBuilder builder() {
        return new ESDTUriBuilder();
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ESDTUri)) {
            return false;
        }
        ESDTUri other = (ESDTUri)o;
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ESDTUri(value=" + this.getValue() + ")";
    }

    @Generated
    public static class ESDTUriBuilder {
        @Generated
        private String value;

        @Generated
        ESDTUriBuilder() {
        }

        @Generated
        public ESDTUriBuilder value(String value) {
            this.value = value;
            return this;
        }

        @Generated
        public ESDTUri build() {
            return new ESDTUri(this.value);
        }

        @Generated
        public String toString() {
            return "ESDTUri.ESDTUriBuilder(value=" + this.value + ")";
        }
    }

    public static enum Type {
        METADATA,
        MEDIA;

    }
}

