/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt;

import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.common.Nonce;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.ESDTTransaction;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.ESDTUri;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenIdentifier;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.TransactionRequest;

public final class NFTAddURI
implements ESDTTransaction {
    @NonNull
    private final TokenIdentifier tokenIdentifier;
    @NonNull
    private final Nonce nonce;
    @NonNull
    private final Set<ESDTUri> uris;
    @NonNull
    private final GasLimit gasLimit;

    private PayloadData processPayloadData() {
        return PayloadData.fromString(String.format("%s@%s@%s@%s", "ESDTNFTAddURI", this.tokenIdentifier.getHex(), this.nonce.getHex(), this.processUris()));
    }

    private String processUris() {
        if (this.uris.isEmpty()) {
            throw new IllegalArgumentException("List of URIs cannot be empty");
        }
        return this.uris.stream().map(ESDTUri::getHex).collect(Collectors.joining("@"));
    }

    @Override
    public TransactionRequest toTransactionRequest(Wallet wallet) {
        return TransactionRequest.builder().receiverAddress(wallet.getAddress()).data(this.processPayloadData()).value(Balance.zero()).gasLimit(this.gasLimit).build();
    }

    @Generated
    private static GasLimit $default$gasLimit() {
        return GasLimit.defaultNftCreate();
    }

    @Generated
    NFTAddURI(@NonNull TokenIdentifier tokenIdentifier, @NonNull Nonce nonce, @NonNull Set<ESDTUri> uris, @NonNull GasLimit gasLimit) {
        if (tokenIdentifier == null) {
            throw new NullPointerException("tokenIdentifier is marked non-null but is null");
        }
        if (nonce == null) {
            throw new NullPointerException("nonce is marked non-null but is null");
        }
        if (uris == null) {
            throw new NullPointerException("uris is marked non-null but is null");
        }
        if (gasLimit == null) {
            throw new NullPointerException("gasLimit is marked non-null but is null");
        }
        this.tokenIdentifier = tokenIdentifier;
        this.nonce = nonce;
        this.uris = uris;
        this.gasLimit = gasLimit;
    }

    @Generated
    public static NFTAddURIBuilder builder() {
        return new NFTAddURIBuilder();
    }

    @NonNull
    @Generated
    public TokenIdentifier getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    @NonNull
    @Generated
    public Nonce getNonce() {
        return this.nonce;
    }

    @NonNull
    @Generated
    public Set<ESDTUri> getUris() {
        return this.uris;
    }

    @NonNull
    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NFTAddURI)) {
            return false;
        }
        NFTAddURI other = (NFTAddURI)o;
        TokenIdentifier this$tokenIdentifier = this.getTokenIdentifier();
        TokenIdentifier other$tokenIdentifier = other.getTokenIdentifier();
        if (this$tokenIdentifier == null ? other$tokenIdentifier != null : !((Object)this$tokenIdentifier).equals(other$tokenIdentifier)) {
            return false;
        }
        Nonce this$nonce = this.getNonce();
        Nonce other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
            return false;
        }
        Set<ESDTUri> this$uris = this.getUris();
        Set<ESDTUri> other$uris = other.getUris();
        if (this$uris == null ? other$uris != null : !((Object)this$uris).equals(other$uris)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        return !(this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TokenIdentifier $tokenIdentifier = this.getTokenIdentifier();
        result = result * 59 + ($tokenIdentifier == null ? 43 : ((Object)$tokenIdentifier).hashCode());
        Nonce $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
        Set<ESDTUri> $uris = this.getUris();
        result = result * 59 + ($uris == null ? 43 : ((Object)$uris).hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NFTAddURI(tokenIdentifier=" + this.getTokenIdentifier() + ", nonce=" + this.getNonce() + ", uris=" + this.getUris() + ", gasLimit=" + this.getGasLimit() + ")";
    }

    @Generated
    public static class NFTAddURIBuilder {
        @Generated
        private TokenIdentifier tokenIdentifier;
        @Generated
        private Nonce nonce;
        @Generated
        private Set<ESDTUri> uris;
        @Generated
        private boolean gasLimit$set;
        @Generated
        private GasLimit gasLimit$value;

        @Generated
        NFTAddURIBuilder() {
        }

        @Generated
        public NFTAddURIBuilder tokenIdentifier(@NonNull TokenIdentifier tokenIdentifier) {
            if (tokenIdentifier == null) {
                throw new NullPointerException("tokenIdentifier is marked non-null but is null");
            }
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        @Generated
        public NFTAddURIBuilder nonce(@NonNull Nonce nonce) {
            if (nonce == null) {
                throw new NullPointerException("nonce is marked non-null but is null");
            }
            this.nonce = nonce;
            return this;
        }

        @Generated
        public NFTAddURIBuilder uris(@NonNull Set<ESDTUri> uris) {
            if (uris == null) {
                throw new NullPointerException("uris is marked non-null but is null");
            }
            this.uris = uris;
            return this;
        }

        @Generated
        public NFTAddURIBuilder gasLimit(@NonNull GasLimit gasLimit) {
            if (gasLimit == null) {
                throw new NullPointerException("gasLimit is marked non-null but is null");
            }
            this.gasLimit$value = gasLimit;
            this.gasLimit$set = true;
            return this;
        }

        @Generated
        public NFTAddURI build() {
            GasLimit gasLimit$value = this.gasLimit$value;
            if (!this.gasLimit$set) {
                gasLimit$value = NFTAddURI.$default$gasLimit();
            }
            return new NFTAddURI(this.tokenIdentifier, this.nonce, this.uris, gasLimit$value);
        }

        @Generated
        public String toString() {
            return "NFTAddURI.NFTAddURIBuilder(tokenIdentifier=" + this.tokenIdentifier + ", nonce=" + this.nonce + ", uris=" + this.uris + ", gasLimit$value=" + this.gasLimit$value + ")";
        }
    }
}

