/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.ESDTTransaction;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenIdentifier;
import software.crldev.elrondspringbootstarterreactive.domain.smartcontract.FunctionArg;
import software.crldev.elrondspringbootstarterreactive.domain.smartcontract.FunctionName;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.TransactionRequest;

public final class ESDTTransfer
implements ESDTTransaction {
    @NonNull
    private final Address receiverAddress;
    @NonNull
    private final TokenIdentifier tokenIdentifier;
    @NonNull
    private final Balance amount;
    @NonNull
    private final FunctionName functionName;
    @NonNull
    private final List<FunctionArg> args;
    @NonNull
    private final GasLimit gasLimit;

    private PayloadData processPayloadData() {
        String functionCall = this.functionName.isEmpty() ? "" : "@" + this.functionName.getHex() + this.args.stream().map(p -> "@" + p.getHex()).collect(Collectors.joining());
        return PayloadData.fromString(String.format("%s@%s@%s%s", "ESDTTransfer", this.tokenIdentifier.getHex(), this.amount.getHex(), functionCall));
    }

    @Override
    public TransactionRequest toTransactionRequest(Wallet wallet) {
        return TransactionRequest.builder().receiverAddress(this.receiverAddress).data(this.processPayloadData()).value(Balance.zero()).gasLimit(this.gasLimit).build();
    }

    @Generated
    private static FunctionName $default$functionName() {
        return FunctionName.empty();
    }

    @Generated
    private static List<FunctionArg> $default$args() {
        return Collections.emptyList();
    }

    @Generated
    private static GasLimit $default$gasLimit() {
        return GasLimit.defaultEsdtTransfer();
    }

    @Generated
    ESDTTransfer(@NonNull Address receiverAddress, @NonNull TokenIdentifier tokenIdentifier, @NonNull Balance amount, @NonNull FunctionName functionName, @NonNull List<FunctionArg> args, @NonNull GasLimit gasLimit) {
        if (receiverAddress == null) {
            throw new NullPointerException("receiverAddress is marked non-null but is null");
        }
        if (tokenIdentifier == null) {
            throw new NullPointerException("tokenIdentifier is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (functionName == null) {
            throw new NullPointerException("functionName is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        if (gasLimit == null) {
            throw new NullPointerException("gasLimit is marked non-null but is null");
        }
        this.receiverAddress = receiverAddress;
        this.tokenIdentifier = tokenIdentifier;
        this.amount = amount;
        this.functionName = functionName;
        this.args = args;
        this.gasLimit = gasLimit;
    }

    @Generated
    public static ESDTTransferBuilder builder() {
        return new ESDTTransferBuilder();
    }

    @NonNull
    @Generated
    public Address getReceiverAddress() {
        return this.receiverAddress;
    }

    @NonNull
    @Generated
    public TokenIdentifier getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    @NonNull
    @Generated
    public Balance getAmount() {
        return this.amount;
    }

    @NonNull
    @Generated
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    @NonNull
    @Generated
    public List<FunctionArg> getArgs() {
        return this.args;
    }

    @NonNull
    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ESDTTransfer)) {
            return false;
        }
        ESDTTransfer other = (ESDTTransfer)o;
        Address this$receiverAddress = this.getReceiverAddress();
        Address other$receiverAddress = other.getReceiverAddress();
        if (this$receiverAddress == null ? other$receiverAddress != null : !this$receiverAddress.equals(other$receiverAddress)) {
            return false;
        }
        TokenIdentifier this$tokenIdentifier = this.getTokenIdentifier();
        TokenIdentifier other$tokenIdentifier = other.getTokenIdentifier();
        if (this$tokenIdentifier == null ? other$tokenIdentifier != null : !((Object)this$tokenIdentifier).equals(other$tokenIdentifier)) {
            return false;
        }
        Balance this$amount = this.getAmount();
        Balance other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        FunctionName this$functionName = this.getFunctionName();
        FunctionName other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !((Object)this$functionName).equals(other$functionName)) {
            return false;
        }
        List<FunctionArg> this$args = this.getArgs();
        List<FunctionArg> other$args = other.getArgs();
        if (this$args == null ? other$args != null : !((Object)this$args).equals(other$args)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        return !(this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Address $receiverAddress = this.getReceiverAddress();
        result = result * 59 + ($receiverAddress == null ? 43 : $receiverAddress.hashCode());
        TokenIdentifier $tokenIdentifier = this.getTokenIdentifier();
        result = result * 59 + ($tokenIdentifier == null ? 43 : ((Object)$tokenIdentifier).hashCode());
        Balance $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        FunctionName $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : ((Object)$functionName).hashCode());
        List<FunctionArg> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ESDTTransfer(receiverAddress=" + this.getReceiverAddress() + ", tokenIdentifier=" + this.getTokenIdentifier() + ", amount=" + this.getAmount() + ", functionName=" + this.getFunctionName() + ", args=" + this.getArgs() + ", gasLimit=" + this.getGasLimit() + ")";
    }

    @Generated
    public static class ESDTTransferBuilder {
        @Generated
        private Address receiverAddress;
        @Generated
        private TokenIdentifier tokenIdentifier;
        @Generated
        private Balance amount;
        @Generated
        private boolean functionName$set;
        @Generated
        private FunctionName functionName$value;
        @Generated
        private boolean args$set;
        @Generated
        private List<FunctionArg> args$value;
        @Generated
        private boolean gasLimit$set;
        @Generated
        private GasLimit gasLimit$value;

        @Generated
        ESDTTransferBuilder() {
        }

        @Generated
        public ESDTTransferBuilder receiverAddress(@NonNull Address receiverAddress) {
            if (receiverAddress == null) {
                throw new NullPointerException("receiverAddress is marked non-null but is null");
            }
            this.receiverAddress = receiverAddress;
            return this;
        }

        @Generated
        public ESDTTransferBuilder tokenIdentifier(@NonNull TokenIdentifier tokenIdentifier) {
            if (tokenIdentifier == null) {
                throw new NullPointerException("tokenIdentifier is marked non-null but is null");
            }
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        @Generated
        public ESDTTransferBuilder amount(@NonNull Balance amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = amount;
            return this;
        }

        @Generated
        public ESDTTransferBuilder functionName(@NonNull FunctionName functionName) {
            if (functionName == null) {
                throw new NullPointerException("functionName is marked non-null but is null");
            }
            this.functionName$value = functionName;
            this.functionName$set = true;
            return this;
        }

        @Generated
        public ESDTTransferBuilder args(@NonNull List<FunctionArg> args) {
            if (args == null) {
                throw new NullPointerException("args is marked non-null but is null");
            }
            this.args$value = args;
            this.args$set = true;
            return this;
        }

        @Generated
        public ESDTTransferBuilder gasLimit(@NonNull GasLimit gasLimit) {
            if (gasLimit == null) {
                throw new NullPointerException("gasLimit is marked non-null but is null");
            }
            this.gasLimit$value = gasLimit;
            this.gasLimit$set = true;
            return this;
        }

        @Generated
        public ESDTTransfer build() {
            FunctionName functionName$value = this.functionName$value;
            if (!this.functionName$set) {
                functionName$value = ESDTTransfer.$default$functionName();
            }
            List<FunctionArg> args$value = this.args$value;
            if (!this.args$set) {
                args$value = ESDTTransfer.$default$args();
            }
            GasLimit gasLimit$value = this.gasLimit$value;
            if (!this.gasLimit$set) {
                gasLimit$value = ESDTTransfer.$default$gasLimit();
            }
            return new ESDTTransfer(this.receiverAddress, this.tokenIdentifier, this.amount, functionName$value, args$value, gasLimit$value);
        }

        @Generated
        public String toString() {
            return "ESDTTransfer.ESDTTransferBuilder(receiverAddress=" + this.receiverAddress + ", tokenIdentifier=" + this.tokenIdentifier + ", amount=" + this.amount + ", functionName$value=" + this.functionName$value + ", args$value=" + this.args$value + ", gasLimit$value=" + this.gasLimit$value + ")";
        }
    }
}

