/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt;

import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.ESDTTransaction;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.ESDTSpecialRole;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenIdentifier;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.error.ErrorMessage;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.TransactionRequest;

public final class ESDTRoleAssignment
implements ESDTTransaction {
    @NonNull
    private final Type type;
    @NonNull
    private final TokenIdentifier tokenIdentifier;
    @NonNull
    private final Address address;
    @NonNull
    private final Set<ESDTSpecialRole> roles;
    @NonNull
    private final GasLimit gasLimit;

    private PayloadData processPayloadData() {
        if (this.roles.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessage.TOKEN_ROLE.getValue());
        }
        return PayloadData.fromString(String.format("%s@%s@%s@%s", this.processType(), this.tokenIdentifier.getHex(), this.address.getHex(), this.roles.stream().map(ESDTSpecialRole::getHex).collect(Collectors.joining("@"))));
    }

    @Override
    public TransactionRequest toTransactionRequest(Wallet wallet) {
        return TransactionRequest.builder().receiverAddress(Address.fromBech32("erd1qqqqqqqqqqqqqqqpqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqzllls8a5w6u")).data(this.processPayloadData()).value(Balance.zero()).gasLimit(this.gasLimit).build();
    }

    private String processType() {
        return this.type.equals((Object)Type.SET) ? "setSpecialRole" : "unSetSpecialRole";
    }

    @Generated
    private static GasLimit $default$gasLimit() {
        return GasLimit.defaultEsdtIssuance();
    }

    @Generated
    ESDTRoleAssignment(@NonNull Type type, @NonNull TokenIdentifier tokenIdentifier, @NonNull Address address, @NonNull Set<ESDTSpecialRole> roles, @NonNull GasLimit gasLimit) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (tokenIdentifier == null) {
            throw new NullPointerException("tokenIdentifier is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (roles == null) {
            throw new NullPointerException("roles is marked non-null but is null");
        }
        if (gasLimit == null) {
            throw new NullPointerException("gasLimit is marked non-null but is null");
        }
        this.type = type;
        this.tokenIdentifier = tokenIdentifier;
        this.address = address;
        this.roles = roles;
        this.gasLimit = gasLimit;
    }

    @Generated
    public static ESDTRoleAssignmentBuilder builder() {
        return new ESDTRoleAssignmentBuilder();
    }

    @NonNull
    @Generated
    public Type getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public TokenIdentifier getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    @NonNull
    @Generated
    public Address getAddress() {
        return this.address;
    }

    @NonNull
    @Generated
    public Set<ESDTSpecialRole> getRoles() {
        return this.roles;
    }

    @NonNull
    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ESDTRoleAssignment)) {
            return false;
        }
        ESDTRoleAssignment other = (ESDTRoleAssignment)o;
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        TokenIdentifier this$tokenIdentifier = this.getTokenIdentifier();
        TokenIdentifier other$tokenIdentifier = other.getTokenIdentifier();
        if (this$tokenIdentifier == null ? other$tokenIdentifier != null : !((Object)this$tokenIdentifier).equals(other$tokenIdentifier)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        Set<ESDTSpecialRole> this$roles = this.getRoles();
        Set<ESDTSpecialRole> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        return !(this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        TokenIdentifier $tokenIdentifier = this.getTokenIdentifier();
        result = result * 59 + ($tokenIdentifier == null ? 43 : ((Object)$tokenIdentifier).hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        Set<ESDTSpecialRole> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ESDTRoleAssignment(type=" + this.getType() + ", tokenIdentifier=" + this.getTokenIdentifier() + ", address=" + this.getAddress() + ", roles=" + this.getRoles() + ", gasLimit=" + this.getGasLimit() + ")";
    }

    @Generated
    public static class ESDTRoleAssignmentBuilder {
        @Generated
        private Type type;
        @Generated
        private TokenIdentifier tokenIdentifier;
        @Generated
        private Address address;
        @Generated
        private Set<ESDTSpecialRole> roles;
        @Generated
        private boolean gasLimit$set;
        @Generated
        private GasLimit gasLimit$value;

        @Generated
        ESDTRoleAssignmentBuilder() {
        }

        @Generated
        public ESDTRoleAssignmentBuilder type(@NonNull Type type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @Generated
        public ESDTRoleAssignmentBuilder tokenIdentifier(@NonNull TokenIdentifier tokenIdentifier) {
            if (tokenIdentifier == null) {
                throw new NullPointerException("tokenIdentifier is marked non-null but is null");
            }
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        @Generated
        public ESDTRoleAssignmentBuilder address(@NonNull Address address) {
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            this.address = address;
            return this;
        }

        @Generated
        public ESDTRoleAssignmentBuilder roles(@NonNull Set<ESDTSpecialRole> roles) {
            if (roles == null) {
                throw new NullPointerException("roles is marked non-null but is null");
            }
            this.roles = roles;
            return this;
        }

        @Generated
        public ESDTRoleAssignmentBuilder gasLimit(@NonNull GasLimit gasLimit) {
            if (gasLimit == null) {
                throw new NullPointerException("gasLimit is marked non-null but is null");
            }
            this.gasLimit$value = gasLimit;
            this.gasLimit$set = true;
            return this;
        }

        @Generated
        public ESDTRoleAssignment build() {
            GasLimit gasLimit$value = this.gasLimit$value;
            if (!this.gasLimit$set) {
                gasLimit$value = ESDTRoleAssignment.$default$gasLimit();
            }
            return new ESDTRoleAssignment(this.type, this.tokenIdentifier, this.address, this.roles, gasLimit$value);
        }

        @Generated
        public String toString() {
            return "ESDTRoleAssignment.ESDTRoleAssignmentBuilder(type=" + this.type + ", tokenIdentifier=" + this.tokenIdentifier + ", address=" + this.address + ", roles=" + this.roles + ", gasLimit$value=" + this.gasLimit$value + ")";
        }
    }

    public static enum Type {
        SET,
        UNSET;

    }
}

