/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt;

import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.ESDTTransaction;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenIdentifier;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.TransactionRequest;

public final class ESDTOwnershipTransfer
implements ESDTTransaction {
    @NonNull
    private final TokenIdentifier tokenIdentifier;
    @NonNull
    private final Address targetAddress;
    @NonNull
    private final GasLimit gasLimit;

    private PayloadData processPayloadData() {
        return PayloadData.fromString(String.format("%s@%s@%s", "transferOwnership", this.tokenIdentifier.getHex(), this.targetAddress.getHex()));
    }

    @Override
    public TransactionRequest toTransactionRequest(Wallet wallet) {
        return TransactionRequest.builder().receiverAddress(Address.fromBech32("erd1qqqqqqqqqqqqqqqpqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqzllls8a5w6u")).data(this.processPayloadData()).value(Balance.zero()).gasLimit(this.gasLimit).build();
    }

    @Generated
    private static GasLimit $default$gasLimit() {
        return GasLimit.defaultEsdtIssuance();
    }

    @Generated
    ESDTOwnershipTransfer(@NonNull TokenIdentifier tokenIdentifier, @NonNull Address targetAddress, @NonNull GasLimit gasLimit) {
        if (tokenIdentifier == null) {
            throw new NullPointerException("tokenIdentifier is marked non-null but is null");
        }
        if (targetAddress == null) {
            throw new NullPointerException("targetAddress is marked non-null but is null");
        }
        if (gasLimit == null) {
            throw new NullPointerException("gasLimit is marked non-null but is null");
        }
        this.tokenIdentifier = tokenIdentifier;
        this.targetAddress = targetAddress;
        this.gasLimit = gasLimit;
    }

    @Generated
    public static ESDTOwnershipTransferBuilder builder() {
        return new ESDTOwnershipTransferBuilder();
    }

    @NonNull
    @Generated
    public TokenIdentifier getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    @NonNull
    @Generated
    public Address getTargetAddress() {
        return this.targetAddress;
    }

    @NonNull
    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ESDTOwnershipTransfer)) {
            return false;
        }
        ESDTOwnershipTransfer other = (ESDTOwnershipTransfer)o;
        TokenIdentifier this$tokenIdentifier = this.getTokenIdentifier();
        TokenIdentifier other$tokenIdentifier = other.getTokenIdentifier();
        if (this$tokenIdentifier == null ? other$tokenIdentifier != null : !((Object)this$tokenIdentifier).equals(other$tokenIdentifier)) {
            return false;
        }
        Address this$targetAddress = this.getTargetAddress();
        Address other$targetAddress = other.getTargetAddress();
        if (this$targetAddress == null ? other$targetAddress != null : !this$targetAddress.equals(other$targetAddress)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        return !(this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TokenIdentifier $tokenIdentifier = this.getTokenIdentifier();
        result = result * 59 + ($tokenIdentifier == null ? 43 : ((Object)$tokenIdentifier).hashCode());
        Address $targetAddress = this.getTargetAddress();
        result = result * 59 + ($targetAddress == null ? 43 : $targetAddress.hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ESDTOwnershipTransfer(tokenIdentifier=" + this.getTokenIdentifier() + ", targetAddress=" + this.getTargetAddress() + ", gasLimit=" + this.getGasLimit() + ")";
    }

    @Generated
    public static class ESDTOwnershipTransferBuilder {
        @Generated
        private TokenIdentifier tokenIdentifier;
        @Generated
        private Address targetAddress;
        @Generated
        private boolean gasLimit$set;
        @Generated
        private GasLimit gasLimit$value;

        @Generated
        ESDTOwnershipTransferBuilder() {
        }

        @Generated
        public ESDTOwnershipTransferBuilder tokenIdentifier(@NonNull TokenIdentifier tokenIdentifier) {
            if (tokenIdentifier == null) {
                throw new NullPointerException("tokenIdentifier is marked non-null but is null");
            }
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        @Generated
        public ESDTOwnershipTransferBuilder targetAddress(@NonNull Address targetAddress) {
            if (targetAddress == null) {
                throw new NullPointerException("targetAddress is marked non-null but is null");
            }
            this.targetAddress = targetAddress;
            return this;
        }

        @Generated
        public ESDTOwnershipTransferBuilder gasLimit(@NonNull GasLimit gasLimit) {
            if (gasLimit == null) {
                throw new NullPointerException("gasLimit is marked non-null but is null");
            }
            this.gasLimit$value = gasLimit;
            this.gasLimit$set = true;
            return this;
        }

        @Generated
        public ESDTOwnershipTransfer build() {
            GasLimit gasLimit$value = this.gasLimit$value;
            if (!this.gasLimit$set) {
                gasLimit$value = ESDTOwnershipTransfer.$default$gasLimit();
            }
            return new ESDTOwnershipTransfer(this.tokenIdentifier, this.targetAddress, gasLimit$value);
        }

        @Generated
        public String toString() {
            return "ESDTOwnershipTransfer.ESDTOwnershipTransferBuilder(tokenIdentifier=" + this.tokenIdentifier + ", targetAddress=" + this.targetAddress + ", gasLimit$value=" + this.gasLimit$value + ")";
        }
    }
}

