/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt.common;

import io.netty.util.internal.StringUtil;
import lombok.Generated;
import org.bouncycastle.util.encoders.Hex;
import software.crldev.elrondspringbootstarterreactive.error.ErrorMessage;

public final class TokenIdentifier {
    private final String value;

    private TokenIdentifier(String name) {
        this.value = name;
    }

    public static TokenIdentifier fromString(String name) {
        if (StringUtil.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException(ErrorMessage.TOKEN_IDENTIFIER.getValue());
        }
        String value = name.replaceAll("\\s+", "").toLowerCase();
        TokenIdentifier.verifyFormat(value);
        return new TokenIdentifier(String.format("%s-%s", value.split("-")[0].toUpperCase(), value.split("-")[1].toLowerCase()));
    }

    public String getHex() {
        return Hex.toHexString((byte[])this.value.getBytes());
    }

    public String toString() {
        return this.value;
    }

    private static void verifyFormat(String value) {
        if (!value.matches("^[a-zA-Z0-9]{3,10}+-[a-zA-Z0-9]{6}+$")) {
            throw new IllegalArgumentException(ErrorMessage.TOKEN_IDENTIFIER.getValue());
        }
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TokenIdentifier)) {
            return false;
        }
        TokenIdentifier other = (TokenIdentifier)o;
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

