/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt;

import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.common.Nonce;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.ESDTTransaction;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenIdentifier;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.TransactionRequest;

public final class NFTSFTGlobalOp
implements ESDTTransaction {
    @NonNull
    private final Type type;
    @NonNull
    private final TokenIdentifier tokenIdentifier;
    @NonNull
    private final Nonce nonce;
    @NonNull
    private final Address address;
    @NonNull
    private final GasLimit gasLimit;

    private PayloadData processPayloadData() {
        return PayloadData.fromString(String.format("%s@%s@%s@%s", this.processType(), this.tokenIdentifier.getHex(), this.nonce.getHex(), this.address.getHex()));
    }

    @Override
    public TransactionRequest toTransactionRequest(Wallet wallet) {
        return TransactionRequest.builder().receiverAddress(Address.fromBech32("erd1qqqqqqqqqqqqqqqpqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqzllls8a5w6u")).data(this.processPayloadData()).value(Balance.zero()).gasLimit(this.gasLimit).build();
    }

    private String processType() {
        switch (this.type) {
            case FREEZE: {
                return "freezeSingleNFT";
            }
            case UNFREEZE: {
                return "unFreezeSingleNFT";
            }
            case WIPE: {
                return "wipeSingleNFT";
            }
        }
        throw new IllegalArgumentException();
    }

    @Generated
    private static GasLimit $default$gasLimit() {
        return GasLimit.defaultEsdtGlobalOp();
    }

    @Generated
    NFTSFTGlobalOp(@NonNull Type type, @NonNull TokenIdentifier tokenIdentifier, @NonNull Nonce nonce, @NonNull Address address, @NonNull GasLimit gasLimit) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (tokenIdentifier == null) {
            throw new NullPointerException("tokenIdentifier is marked non-null but is null");
        }
        if (nonce == null) {
            throw new NullPointerException("nonce is marked non-null but is null");
        }
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (gasLimit == null) {
            throw new NullPointerException("gasLimit is marked non-null but is null");
        }
        this.type = type;
        this.tokenIdentifier = tokenIdentifier;
        this.nonce = nonce;
        this.address = address;
        this.gasLimit = gasLimit;
    }

    @Generated
    public static NFTSFTGlobalOpBuilder builder() {
        return new NFTSFTGlobalOpBuilder();
    }

    @NonNull
    @Generated
    public Type getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public TokenIdentifier getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    @NonNull
    @Generated
    public Nonce getNonce() {
        return this.nonce;
    }

    @NonNull
    @Generated
    public Address getAddress() {
        return this.address;
    }

    @NonNull
    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NFTSFTGlobalOp)) {
            return false;
        }
        NFTSFTGlobalOp other = (NFTSFTGlobalOp)o;
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        TokenIdentifier this$tokenIdentifier = this.getTokenIdentifier();
        TokenIdentifier other$tokenIdentifier = other.getTokenIdentifier();
        if (this$tokenIdentifier == null ? other$tokenIdentifier != null : !((Object)this$tokenIdentifier).equals(other$tokenIdentifier)) {
            return false;
        }
        Nonce this$nonce = this.getNonce();
        Nonce other$nonce = other.getNonce();
        if (this$nonce == null ? other$nonce != null : !((Object)this$nonce).equals(other$nonce)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        return !(this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        TokenIdentifier $tokenIdentifier = this.getTokenIdentifier();
        result = result * 59 + ($tokenIdentifier == null ? 43 : ((Object)$tokenIdentifier).hashCode());
        Nonce $nonce = this.getNonce();
        result = result * 59 + ($nonce == null ? 43 : ((Object)$nonce).hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "NFTSFTGlobalOp(type=" + this.getType() + ", tokenIdentifier=" + this.getTokenIdentifier() + ", nonce=" + this.getNonce() + ", address=" + this.getAddress() + ", gasLimit=" + this.getGasLimit() + ")";
    }

    @Generated
    public static class NFTSFTGlobalOpBuilder {
        @Generated
        private Type type;
        @Generated
        private TokenIdentifier tokenIdentifier;
        @Generated
        private Nonce nonce;
        @Generated
        private Address address;
        @Generated
        private boolean gasLimit$set;
        @Generated
        private GasLimit gasLimit$value;

        @Generated
        NFTSFTGlobalOpBuilder() {
        }

        @Generated
        public NFTSFTGlobalOpBuilder type(@NonNull Type type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @Generated
        public NFTSFTGlobalOpBuilder tokenIdentifier(@NonNull TokenIdentifier tokenIdentifier) {
            if (tokenIdentifier == null) {
                throw new NullPointerException("tokenIdentifier is marked non-null but is null");
            }
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        @Generated
        public NFTSFTGlobalOpBuilder nonce(@NonNull Nonce nonce) {
            if (nonce == null) {
                throw new NullPointerException("nonce is marked non-null but is null");
            }
            this.nonce = nonce;
            return this;
        }

        @Generated
        public NFTSFTGlobalOpBuilder address(@NonNull Address address) {
            if (address == null) {
                throw new NullPointerException("address is marked non-null but is null");
            }
            this.address = address;
            return this;
        }

        @Generated
        public NFTSFTGlobalOpBuilder gasLimit(@NonNull GasLimit gasLimit) {
            if (gasLimit == null) {
                throw new NullPointerException("gasLimit is marked non-null but is null");
            }
            this.gasLimit$value = gasLimit;
            this.gasLimit$set = true;
            return this;
        }

        @Generated
        public NFTSFTGlobalOp build() {
            GasLimit gasLimit$value = this.gasLimit$value;
            if (!this.gasLimit$set) {
                gasLimit$value = NFTSFTGlobalOp.$default$gasLimit();
            }
            return new NFTSFTGlobalOp(this.type, this.tokenIdentifier, this.nonce, this.address, gasLimit$value);
        }

        @Generated
        public String toString() {
            return "NFTSFTGlobalOp.NFTSFTGlobalOpBuilder(type=" + this.type + ", tokenIdentifier=" + this.tokenIdentifier + ", nonce=" + this.nonce + ", address=" + this.address + ", gasLimit$value=" + this.gasLimit$value + ")";
        }
    }

    public static enum Type {
        FREEZE,
        UNFREEZE,
        WIPE;

    }
}

