/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt;

import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.ESDTTransaction;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenIdentifier;
import software.crldev.elrondspringbootstarterreactive.domain.smartcontract.FunctionArgs;
import software.crldev.elrondspringbootstarterreactive.domain.smartcontract.FunctionName;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.TransactionRequest;

public final class ESDTTransfer
implements ESDTTransaction {
    @NonNull
    private final Address receiverAddress;
    @NonNull
    private final TokenIdentifier tokenIdentifier;
    @NonNull
    private final Balance amount;
    @NonNull
    private final FunctionName functionName;
    @NonNull
    private final FunctionArgs functionArgs;
    @NonNull
    private final GasLimit gasLimit;

    private PayloadData processPayloadData() {
        String functionCall = this.functionName.isEmpty() ? "" : "@" + this.functionName.getHex() + this.functionArgs.getHex().stream().map("@"::concat).collect(Collectors.joining());
        return PayloadData.fromString(String.format("%s@%s@%s%s", "ESDTTransfer", this.tokenIdentifier.getHex(), this.amount.getHex(), functionCall));
    }

    @Override
    public TransactionRequest toTransactionRequest(Wallet wallet) {
        return TransactionRequest.builder().receiverAddress(this.receiverAddress).data(this.processPayloadData()).value(Balance.zero()).gasLimit(this.gasLimit).build();
    }

    @Generated
    private static FunctionName $default$functionName() {
        return FunctionName.empty();
    }

    @Generated
    private static FunctionArgs $default$functionArgs() {
        return FunctionArgs.empty();
    }

    @Generated
    private static GasLimit $default$gasLimit() {
        return GasLimit.defaultEsdtTransfer();
    }

    @Generated
    ESDTTransfer(@NonNull Address receiverAddress, @NonNull TokenIdentifier tokenIdentifier, @NonNull Balance amount, @NonNull FunctionName functionName, @NonNull FunctionArgs functionArgs, @NonNull GasLimit gasLimit) {
        if (receiverAddress == null) {
            throw new NullPointerException("receiverAddress is marked non-null but is null");
        }
        if (tokenIdentifier == null) {
            throw new NullPointerException("tokenIdentifier is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (functionName == null) {
            throw new NullPointerException("functionName is marked non-null but is null");
        }
        if (functionArgs == null) {
            throw new NullPointerException("functionArgs is marked non-null but is null");
        }
        if (gasLimit == null) {
            throw new NullPointerException("gasLimit is marked non-null but is null");
        }
        this.receiverAddress = receiverAddress;
        this.tokenIdentifier = tokenIdentifier;
        this.amount = amount;
        this.functionName = functionName;
        this.functionArgs = functionArgs;
        this.gasLimit = gasLimit;
    }

    @Generated
    public static ESDTTransferBuilder builder() {
        return new ESDTTransferBuilder();
    }

    @NonNull
    @Generated
    public Address getReceiverAddress() {
        return this.receiverAddress;
    }

    @NonNull
    @Generated
    public TokenIdentifier getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    @NonNull
    @Generated
    public Balance getAmount() {
        return this.amount;
    }

    @NonNull
    @Generated
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    @NonNull
    @Generated
    public FunctionArgs getFunctionArgs() {
        return this.functionArgs;
    }

    @NonNull
    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ESDTTransfer)) {
            return false;
        }
        ESDTTransfer other = (ESDTTransfer)o;
        Address this$receiverAddress = this.getReceiverAddress();
        Address other$receiverAddress = other.getReceiverAddress();
        if (this$receiverAddress == null ? other$receiverAddress != null : !this$receiverAddress.equals(other$receiverAddress)) {
            return false;
        }
        TokenIdentifier this$tokenIdentifier = this.getTokenIdentifier();
        TokenIdentifier other$tokenIdentifier = other.getTokenIdentifier();
        if (this$tokenIdentifier == null ? other$tokenIdentifier != null : !((Object)this$tokenIdentifier).equals(other$tokenIdentifier)) {
            return false;
        }
        Balance this$amount = this.getAmount();
        Balance other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        FunctionName this$functionName = this.getFunctionName();
        FunctionName other$functionName = other.getFunctionName();
        if (this$functionName == null ? other$functionName != null : !((Object)this$functionName).equals(other$functionName)) {
            return false;
        }
        FunctionArgs this$functionArgs = this.getFunctionArgs();
        FunctionArgs other$functionArgs = other.getFunctionArgs();
        if (this$functionArgs == null ? other$functionArgs != null : !((Object)this$functionArgs).equals(other$functionArgs)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        return !(this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Address $receiverAddress = this.getReceiverAddress();
        result = result * 59 + ($receiverAddress == null ? 43 : $receiverAddress.hashCode());
        TokenIdentifier $tokenIdentifier = this.getTokenIdentifier();
        result = result * 59 + ($tokenIdentifier == null ? 43 : ((Object)$tokenIdentifier).hashCode());
        Balance $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        FunctionName $functionName = this.getFunctionName();
        result = result * 59 + ($functionName == null ? 43 : ((Object)$functionName).hashCode());
        FunctionArgs $functionArgs = this.getFunctionArgs();
        result = result * 59 + ($functionArgs == null ? 43 : ((Object)$functionArgs).hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ESDTTransfer(receiverAddress=" + this.getReceiverAddress() + ", tokenIdentifier=" + this.getTokenIdentifier() + ", amount=" + this.getAmount() + ", functionName=" + this.getFunctionName() + ", functionArgs=" + this.getFunctionArgs() + ", gasLimit=" + this.getGasLimit() + ")";
    }

    @Generated
    public static class ESDTTransferBuilder {
        @Generated
        private Address receiverAddress;
        @Generated
        private TokenIdentifier tokenIdentifier;
        @Generated
        private Balance amount;
        @Generated
        private boolean functionName$set;
        @Generated
        private FunctionName functionName$value;
        @Generated
        private boolean functionArgs$set;
        @Generated
        private FunctionArgs functionArgs$value;
        @Generated
        private boolean gasLimit$set;
        @Generated
        private GasLimit gasLimit$value;

        @Generated
        ESDTTransferBuilder() {
        }

        @Generated
        public ESDTTransferBuilder receiverAddress(@NonNull Address receiverAddress) {
            if (receiverAddress == null) {
                throw new NullPointerException("receiverAddress is marked non-null but is null");
            }
            this.receiverAddress = receiverAddress;
            return this;
        }

        @Generated
        public ESDTTransferBuilder tokenIdentifier(@NonNull TokenIdentifier tokenIdentifier) {
            if (tokenIdentifier == null) {
                throw new NullPointerException("tokenIdentifier is marked non-null but is null");
            }
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        @Generated
        public ESDTTransferBuilder amount(@NonNull Balance amount) {
            if (amount == null) {
                throw new NullPointerException("amount is marked non-null but is null");
            }
            this.amount = amount;
            return this;
        }

        @Generated
        public ESDTTransferBuilder functionName(@NonNull FunctionName functionName) {
            if (functionName == null) {
                throw new NullPointerException("functionName is marked non-null but is null");
            }
            this.functionName$value = functionName;
            this.functionName$set = true;
            return this;
        }

        @Generated
        public ESDTTransferBuilder functionArgs(@NonNull FunctionArgs functionArgs) {
            if (functionArgs == null) {
                throw new NullPointerException("functionArgs is marked non-null but is null");
            }
            this.functionArgs$value = functionArgs;
            this.functionArgs$set = true;
            return this;
        }

        @Generated
        public ESDTTransferBuilder gasLimit(@NonNull GasLimit gasLimit) {
            if (gasLimit == null) {
                throw new NullPointerException("gasLimit is marked non-null but is null");
            }
            this.gasLimit$value = gasLimit;
            this.gasLimit$set = true;
            return this;
        }

        @Generated
        public ESDTTransfer build() {
            FunctionName functionName$value = this.functionName$value;
            if (!this.functionName$set) {
                functionName$value = ESDTTransfer.$default$functionName();
            }
            FunctionArgs functionArgs$value = this.functionArgs$value;
            if (!this.functionArgs$set) {
                functionArgs$value = ESDTTransfer.$default$functionArgs();
            }
            GasLimit gasLimit$value = this.gasLimit$value;
            if (!this.gasLimit$set) {
                gasLimit$value = ESDTTransfer.$default$gasLimit();
            }
            return new ESDTTransfer(this.receiverAddress, this.tokenIdentifier, this.amount, functionName$value, functionArgs$value, gasLimit$value);
        }

        @Generated
        public String toString() {
            return "ESDTTransfer.ESDTTransferBuilder(receiverAddress=" + this.receiverAddress + ", tokenIdentifier=" + this.tokenIdentifier + ", amount=" + this.amount + ", functionName$value=" + this.functionName$value + ", functionArgs$value=" + this.functionArgs$value + ", gasLimit$value=" + this.gasLimit$value + ")";
        }
    }
}

