/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.ESDTTransaction;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TransferToken;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.TransactionRequest;
import software.crldev.elrondspringbootstarterreactive.util.HexValidator;

public final class ESDTNFTMultiTransfer
implements ESDTTransaction {
    @NonNull
    private final Address receiverAddress;
    @NonNull
    private final List<TransferToken> tokenList;

    private PayloadData processPayloadData() {
        return PayloadData.fromString(String.format("%s@%s@%s@%s", "MultiESDTNFTTransfer", this.receiverAddress.getHex(), HexValidator.processNumberHexArgument(Integer.toString(this.tokenList.size(), 16)), this.processTokenList()));
    }

    @Override
    public TransactionRequest toTransactionRequest(Wallet wallet) {
        return TransactionRequest.builder().receiverAddress(wallet.getAddress()).data(this.processPayloadData()).value(Balance.zero()).gasLimit(GasLimit.multiEsdtTransfer(this.tokenList.size())).build();
    }

    private String processTokenList() {
        return this.tokenList.stream().map(t -> t.getIdentifier().getHex() + "@" + t.getNonce().getHex() + "@" + t.getAmount().getHex()).collect(Collectors.joining("@"));
    }

    @Generated
    ESDTNFTMultiTransfer(@NonNull Address receiverAddress, @NonNull List<TransferToken> tokenList) {
        if (receiverAddress == null) {
            throw new NullPointerException("receiverAddress is marked non-null but is null");
        }
        if (tokenList == null) {
            throw new NullPointerException("tokenList is marked non-null but is null");
        }
        this.receiverAddress = receiverAddress;
        this.tokenList = tokenList;
    }

    @Generated
    public static ESDTNFTMultiTransferBuilder builder() {
        return new ESDTNFTMultiTransferBuilder();
    }

    @NonNull
    @Generated
    public Address getReceiverAddress() {
        return this.receiverAddress;
    }

    @NonNull
    @Generated
    public List<TransferToken> getTokenList() {
        return this.tokenList;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ESDTNFTMultiTransfer)) {
            return false;
        }
        ESDTNFTMultiTransfer other = (ESDTNFTMultiTransfer)o;
        Address this$receiverAddress = this.getReceiverAddress();
        Address other$receiverAddress = other.getReceiverAddress();
        if (this$receiverAddress == null ? other$receiverAddress != null : !this$receiverAddress.equals(other$receiverAddress)) {
            return false;
        }
        List<TransferToken> this$tokenList = this.getTokenList();
        List<TransferToken> other$tokenList = other.getTokenList();
        return !(this$tokenList == null ? other$tokenList != null : !((Object)this$tokenList).equals(other$tokenList));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Address $receiverAddress = this.getReceiverAddress();
        result = result * 59 + ($receiverAddress == null ? 43 : $receiverAddress.hashCode());
        List<TransferToken> $tokenList = this.getTokenList();
        result = result * 59 + ($tokenList == null ? 43 : ((Object)$tokenList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ESDTNFTMultiTransfer(receiverAddress=" + this.getReceiverAddress() + ", tokenList=" + this.getTokenList() + ")";
    }

    @Generated
    public static class ESDTNFTMultiTransferBuilder {
        @Generated
        private Address receiverAddress;
        @Generated
        private List<TransferToken> tokenList;

        @Generated
        ESDTNFTMultiTransferBuilder() {
        }

        @Generated
        public ESDTNFTMultiTransferBuilder receiverAddress(@NonNull Address receiverAddress) {
            if (receiverAddress == null) {
                throw new NullPointerException("receiverAddress is marked non-null but is null");
            }
            this.receiverAddress = receiverAddress;
            return this;
        }

        @Generated
        public ESDTNFTMultiTransferBuilder tokenList(@NonNull List<TransferToken> tokenList) {
            if (tokenList == null) {
                throw new NullPointerException("tokenList is marked non-null but is null");
            }
            this.tokenList = tokenList;
            return this;
        }

        @Generated
        public ESDTNFTMultiTransfer build() {
            return new ESDTNFTMultiTransfer(this.receiverAddress, this.tokenList);
        }

        @Generated
        public String toString() {
            return "ESDTNFTMultiTransfer.ESDTNFTMultiTransferBuilder(receiverAddress=" + this.receiverAddress + ", tokenList=" + this.tokenList + ")";
        }
    }
}

