/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.config.constants.ESDTConstants;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.ESDTTransaction;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenDecimals;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenInitialSupply;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenName;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenProperty;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenPropertyName;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenTicker;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.error.ErrorMessage;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.TransactionRequest;

public final class ESDTIssuance
implements ESDTTransaction {
    @NonNull
    private final Type type;
    @NonNull
    private final TokenName tokenName;
    @NonNull
    private final TokenTicker tokenTicker;
    private final TokenInitialSupply initialSupply;
    private final TokenDecimals decimals;
    private final Balance value;
    private final GasLimit gasLimit;
    private final Set<TokenProperty> properties;

    private PayloadData processPayloadData() {
        return PayloadData.fromString(String.format("%s@%s@%s%s%s%s", this.processType(), this.tokenName.getHex(), this.tokenTicker.getHex(), this.processSupplyArg(), this.processDecimalsArg(), this.processPropsArg()));
    }

    @Override
    public TransactionRequest toTransactionRequest(Wallet wallet) {
        return TransactionRequest.builder().receiverAddress(Address.fromBech32("erd1qqqqqqqqqqqqqqqpqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqzllls8a5w6u")).data(this.processPayloadData()).value(this.value).gasLimit(this.gasLimit).build();
    }

    private String processSupplyArg() {
        if (!this.type.equals((Object)Type.FUNGIBLE)) {
            return "";
        }
        return "@" + this.initialSupply.getHex();
    }

    private String processDecimalsArg() {
        if (!this.type.equals((Object)Type.FUNGIBLE) && !this.type.equals((Object)Type.META)) {
            return "";
        }
        return "@" + this.decimals.getHex();
    }

    private String processPropsArg() {
        this.properties.removeIf(p -> this.type.equals((Object)Type.FUNGIBLE) && p.getName().equals((Object)TokenPropertyName.CAN_TRANSFER_NFT_CREATE_ROLE));
        this.properties.removeIf(p -> !(!this.type.equals((Object)Type.SEMI_FUNGIBLE) && !this.type.equals((Object)Type.NON_FUNGIBLE) && !this.type.equals((Object)Type.META) || !p.getName().equals((Object)TokenPropertyName.CAN_UPGRADE) && !p.getName().equals((Object)TokenPropertyName.CAN_ADD_SPECIAL_ROLES) && !p.getName().equals((Object)TokenPropertyName.CAN_CHANGE_OWNER)));
        return this.properties.stream().map(p -> "@" + p.getNameHex() + "@" + p.getValueHex()).collect(Collectors.joining());
    }

    private String processType() {
        switch (this.type) {
            case FUNGIBLE: {
                this.throwIfNull(this.initialSupply, ErrorMessage.INITIAL_SUPPLY.getValue());
                this.throwIfNull(this.decimals, ErrorMessage.TOKEN_DECIMALS.getValue());
                return "issue";
            }
            case SEMI_FUNGIBLE: {
                return "issueSemiFungible";
            }
            case NON_FUNGIBLE: {
                return "issueNonFungible";
            }
            case META: {
                this.throwIfNull(this.decimals, ErrorMessage.TOKEN_DECIMALS.getValue());
                return "registerMetaESDT";
            }
        }
        throw new IllegalArgumentException();
    }

    private void throwIfNull(Object target, String message) {
        if (!Objects.nonNull(target)) {
            throw new IllegalArgumentException(message);
        }
    }

    @Generated
    private static Balance $default$value() {
        return Balance.fromNumber(ESDTConstants.ESDT_ISSUANCE_EGLD_COST);
    }

    @Generated
    private static GasLimit $default$gasLimit() {
        return GasLimit.defaultEsdtIssuance();
    }

    @Generated
    private static Set<TokenProperty> $default$properties() {
        return new HashSet<TokenProperty>();
    }

    @Generated
    ESDTIssuance(@NonNull Type type, @NonNull TokenName tokenName, @NonNull TokenTicker tokenTicker, TokenInitialSupply initialSupply, TokenDecimals decimals, Balance value, GasLimit gasLimit, Set<TokenProperty> properties) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (tokenName == null) {
            throw new NullPointerException("tokenName is marked non-null but is null");
        }
        if (tokenTicker == null) {
            throw new NullPointerException("tokenTicker is marked non-null but is null");
        }
        this.type = type;
        this.tokenName = tokenName;
        this.tokenTicker = tokenTicker;
        this.initialSupply = initialSupply;
        this.decimals = decimals;
        this.value = value;
        this.gasLimit = gasLimit;
        this.properties = properties;
    }

    @Generated
    public static ESDTIssuanceBuilder builder() {
        return new ESDTIssuanceBuilder();
    }

    @NonNull
    @Generated
    public Type getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public TokenName getTokenName() {
        return this.tokenName;
    }

    @NonNull
    @Generated
    public TokenTicker getTokenTicker() {
        return this.tokenTicker;
    }

    @Generated
    public TokenInitialSupply getInitialSupply() {
        return this.initialSupply;
    }

    @Generated
    public TokenDecimals getDecimals() {
        return this.decimals;
    }

    @Generated
    public Balance getValue() {
        return this.value;
    }

    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public Set<TokenProperty> getProperties() {
        return this.properties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ESDTIssuance)) {
            return false;
        }
        ESDTIssuance other = (ESDTIssuance)o;
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        TokenName this$tokenName = this.getTokenName();
        TokenName other$tokenName = other.getTokenName();
        if (this$tokenName == null ? other$tokenName != null : !((Object)this$tokenName).equals(other$tokenName)) {
            return false;
        }
        TokenTicker this$tokenTicker = this.getTokenTicker();
        TokenTicker other$tokenTicker = other.getTokenTicker();
        if (this$tokenTicker == null ? other$tokenTicker != null : !((Object)this$tokenTicker).equals(other$tokenTicker)) {
            return false;
        }
        TokenInitialSupply this$initialSupply = this.getInitialSupply();
        TokenInitialSupply other$initialSupply = other.getInitialSupply();
        if (this$initialSupply == null ? other$initialSupply != null : !((Object)this$initialSupply).equals(other$initialSupply)) {
            return false;
        }
        TokenDecimals this$decimals = this.getDecimals();
        TokenDecimals other$decimals = other.getDecimals();
        if (this$decimals == null ? other$decimals != null : !((Object)this$decimals).equals(other$decimals)) {
            return false;
        }
        Balance this$value = this.getValue();
        Balance other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        if (this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit)) {
            return false;
        }
        Set<TokenProperty> this$properties = this.getProperties();
        Set<TokenProperty> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        TokenName $tokenName = this.getTokenName();
        result = result * 59 + ($tokenName == null ? 43 : ((Object)$tokenName).hashCode());
        TokenTicker $tokenTicker = this.getTokenTicker();
        result = result * 59 + ($tokenTicker == null ? 43 : ((Object)$tokenTicker).hashCode());
        TokenInitialSupply $initialSupply = this.getInitialSupply();
        result = result * 59 + ($initialSupply == null ? 43 : ((Object)$initialSupply).hashCode());
        TokenDecimals $decimals = this.getDecimals();
        result = result * 59 + ($decimals == null ? 43 : ((Object)$decimals).hashCode());
        Balance $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        Set<TokenProperty> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ESDTIssuance(type=" + this.getType() + ", tokenName=" + this.getTokenName() + ", tokenTicker=" + this.getTokenTicker() + ", initialSupply=" + this.getInitialSupply() + ", decimals=" + this.getDecimals() + ", value=" + this.getValue() + ", gasLimit=" + this.getGasLimit() + ", properties=" + this.getProperties() + ")";
    }

    @Generated
    public static class ESDTIssuanceBuilder {
        @Generated
        private Type type;
        @Generated
        private TokenName tokenName;
        @Generated
        private TokenTicker tokenTicker;
        @Generated
        private TokenInitialSupply initialSupply;
        @Generated
        private TokenDecimals decimals;
        @Generated
        private boolean value$set;
        @Generated
        private Balance value$value;
        @Generated
        private boolean gasLimit$set;
        @Generated
        private GasLimit gasLimit$value;
        @Generated
        private boolean properties$set;
        @Generated
        private Set<TokenProperty> properties$value;

        @Generated
        ESDTIssuanceBuilder() {
        }

        @Generated
        public ESDTIssuanceBuilder type(@NonNull Type type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @Generated
        public ESDTIssuanceBuilder tokenName(@NonNull TokenName tokenName) {
            if (tokenName == null) {
                throw new NullPointerException("tokenName is marked non-null but is null");
            }
            this.tokenName = tokenName;
            return this;
        }

        @Generated
        public ESDTIssuanceBuilder tokenTicker(@NonNull TokenTicker tokenTicker) {
            if (tokenTicker == null) {
                throw new NullPointerException("tokenTicker is marked non-null but is null");
            }
            this.tokenTicker = tokenTicker;
            return this;
        }

        @Generated
        public ESDTIssuanceBuilder initialSupply(TokenInitialSupply initialSupply) {
            this.initialSupply = initialSupply;
            return this;
        }

        @Generated
        public ESDTIssuanceBuilder decimals(TokenDecimals decimals) {
            this.decimals = decimals;
            return this;
        }

        @Generated
        public ESDTIssuanceBuilder value(Balance value) {
            this.value$value = value;
            this.value$set = true;
            return this;
        }

        @Generated
        public ESDTIssuanceBuilder gasLimit(GasLimit gasLimit) {
            this.gasLimit$value = gasLimit;
            this.gasLimit$set = true;
            return this;
        }

        @Generated
        public ESDTIssuanceBuilder properties(Set<TokenProperty> properties) {
            this.properties$value = properties;
            this.properties$set = true;
            return this;
        }

        @Generated
        public ESDTIssuance build() {
            Balance value$value = this.value$value;
            if (!this.value$set) {
                value$value = ESDTIssuance.$default$value();
            }
            GasLimit gasLimit$value = this.gasLimit$value;
            if (!this.gasLimit$set) {
                gasLimit$value = ESDTIssuance.$default$gasLimit();
            }
            Set<TokenProperty> properties$value = this.properties$value;
            if (!this.properties$set) {
                properties$value = ESDTIssuance.$default$properties();
            }
            return new ESDTIssuance(this.type, this.tokenName, this.tokenTicker, this.initialSupply, this.decimals, value$value, gasLimit$value, properties$value);
        }

        @Generated
        public String toString() {
            return "ESDTIssuance.ESDTIssuanceBuilder(type=" + this.type + ", tokenName=" + this.tokenName + ", tokenTicker=" + this.tokenTicker + ", initialSupply=" + this.initialSupply + ", decimals=" + this.decimals + ", value$value=" + this.value$value + ", gasLimit$value=" + this.gasLimit$value + ", properties$value=" + this.properties$value + ")";
        }
    }

    public static enum Type {
        FUNGIBLE,
        SEMI_FUNGIBLE,
        NON_FUNGIBLE,
        META;

    }
}

