/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.esdt;

import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.ESDTTransaction;
import software.crldev.elrondspringbootstarterreactive.domain.esdt.common.TokenIdentifier;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;
import software.crldev.elrondspringbootstarterreactive.domain.wallet.Wallet;
import software.crldev.elrondspringbootstarterreactive.error.ErrorMessage;
import software.crldev.elrondspringbootstarterreactive.interactor.transaction.TransactionRequest;

public final class ESDTGlobalOp
implements ESDTTransaction {
    @NonNull
    private final Type type;
    @NonNull
    private final TokenIdentifier tokenIdentifier;
    @NonNull
    private final Address targetAddress;
    @NonNull
    private final GasLimit gasLimit;

    private PayloadData processPayloadData() {
        return PayloadData.fromString(String.format("%s@%s%s", this.processType(), this.tokenIdentifier.getHex(), this.processAddressArg()));
    }

    @Override
    public TransactionRequest toTransactionRequest(Wallet wallet) {
        return TransactionRequest.builder().receiverAddress(Address.fromBech32("erd1qqqqqqqqqqqqqqqpqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqzllls8a5w6u")).data(this.processPayloadData()).value(Balance.zero()).gasLimit(this.gasLimit).build();
    }

    private String processAddressArg() {
        if (this.type.equals((Object)Type.PAUSE) || this.type.equals((Object)Type.UNPAUSE)) {
            return "";
        }
        return "@" + this.targetAddress.getHex();
    }

    private String processType() {
        switch (this.type) {
            case FREEZE: {
                this.throwIfAddressEmpty();
                return "freeze";
            }
            case UNFREEZE: {
                this.throwIfAddressEmpty();
                return "unFreeze";
            }
            case PAUSE: {
                return "pause";
            }
            case UNPAUSE: {
                return "unPause";
            }
            case WIPE: {
                this.throwIfAddressEmpty();
                return "wipe";
            }
        }
        throw new IllegalArgumentException();
    }

    private void throwIfAddressEmpty() {
        if (this.targetAddress.isZero()) {
            throw new IllegalArgumentException(ErrorMessage.ADDRESS_EMPTY.getValue());
        }
    }

    @Generated
    private static Address $default$targetAddress() {
        return Address.zero();
    }

    @Generated
    private static GasLimit $default$gasLimit() {
        return GasLimit.defaultEsdtIssuance();
    }

    @Generated
    ESDTGlobalOp(@NonNull Type type, @NonNull TokenIdentifier tokenIdentifier, @NonNull Address targetAddress, @NonNull GasLimit gasLimit) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (tokenIdentifier == null) {
            throw new NullPointerException("tokenIdentifier is marked non-null but is null");
        }
        if (targetAddress == null) {
            throw new NullPointerException("targetAddress is marked non-null but is null");
        }
        if (gasLimit == null) {
            throw new NullPointerException("gasLimit is marked non-null but is null");
        }
        this.type = type;
        this.tokenIdentifier = tokenIdentifier;
        this.targetAddress = targetAddress;
        this.gasLimit = gasLimit;
    }

    @Generated
    public static ESDTGlobalOpBuilder builder() {
        return new ESDTGlobalOpBuilder();
    }

    @NonNull
    @Generated
    public Type getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public TokenIdentifier getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    @NonNull
    @Generated
    public Address getTargetAddress() {
        return this.targetAddress;
    }

    @NonNull
    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ESDTGlobalOp)) {
            return false;
        }
        ESDTGlobalOp other = (ESDTGlobalOp)o;
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        TokenIdentifier this$tokenIdentifier = this.getTokenIdentifier();
        TokenIdentifier other$tokenIdentifier = other.getTokenIdentifier();
        if (this$tokenIdentifier == null ? other$tokenIdentifier != null : !((Object)this$tokenIdentifier).equals(other$tokenIdentifier)) {
            return false;
        }
        Address this$targetAddress = this.getTargetAddress();
        Address other$targetAddress = other.getTargetAddress();
        if (this$targetAddress == null ? other$targetAddress != null : !this$targetAddress.equals(other$targetAddress)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        return !(this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        TokenIdentifier $tokenIdentifier = this.getTokenIdentifier();
        result = result * 59 + ($tokenIdentifier == null ? 43 : ((Object)$tokenIdentifier).hashCode());
        Address $targetAddress = this.getTargetAddress();
        result = result * 59 + ($targetAddress == null ? 43 : $targetAddress.hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ESDTGlobalOp(type=" + this.getType() + ", tokenIdentifier=" + this.getTokenIdentifier() + ", targetAddress=" + this.getTargetAddress() + ", gasLimit=" + this.getGasLimit() + ")";
    }

    @Generated
    public static class ESDTGlobalOpBuilder {
        @Generated
        private Type type;
        @Generated
        private TokenIdentifier tokenIdentifier;
        @Generated
        private boolean targetAddress$set;
        @Generated
        private Address targetAddress$value;
        @Generated
        private boolean gasLimit$set;
        @Generated
        private GasLimit gasLimit$value;

        @Generated
        ESDTGlobalOpBuilder() {
        }

        @Generated
        public ESDTGlobalOpBuilder type(@NonNull Type type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @Generated
        public ESDTGlobalOpBuilder tokenIdentifier(@NonNull TokenIdentifier tokenIdentifier) {
            if (tokenIdentifier == null) {
                throw new NullPointerException("tokenIdentifier is marked non-null but is null");
            }
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        @Generated
        public ESDTGlobalOpBuilder targetAddress(@NonNull Address targetAddress) {
            if (targetAddress == null) {
                throw new NullPointerException("targetAddress is marked non-null but is null");
            }
            this.targetAddress$value = targetAddress;
            this.targetAddress$set = true;
            return this;
        }

        @Generated
        public ESDTGlobalOpBuilder gasLimit(@NonNull GasLimit gasLimit) {
            if (gasLimit == null) {
                throw new NullPointerException("gasLimit is marked non-null but is null");
            }
            this.gasLimit$value = gasLimit;
            this.gasLimit$set = true;
            return this;
        }

        @Generated
        public ESDTGlobalOp build() {
            Address targetAddress$value = this.targetAddress$value;
            if (!this.targetAddress$set) {
                targetAddress$value = ESDTGlobalOp.$default$targetAddress();
            }
            GasLimit gasLimit$value = this.gasLimit$value;
            if (!this.gasLimit$set) {
                gasLimit$value = ESDTGlobalOp.$default$gasLimit();
            }
            return new ESDTGlobalOp(this.type, this.tokenIdentifier, targetAddress$value, gasLimit$value);
        }

        @Generated
        public String toString() {
            return "ESDTGlobalOp.ESDTGlobalOpBuilder(type=" + this.type + ", tokenIdentifier=" + this.tokenIdentifier + ", targetAddress$value=" + this.targetAddress$value + ", gasLimit$value=" + this.gasLimit$value + ")";
        }
    }

    public static enum Type {
        PAUSE,
        UNPAUSE,
        FREEZE,
        UNFREEZE,
        WIPE;

    }
}

