/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.domain.account;

import org.bitcoinj.core.Bech32;
import org.bouncycastle.util.encoders.Hex;
import software.crldev.elrondspringbootstarterreactive.error.exception.CannotDecodeBech32AddressException;
import software.crldev.elrondspringbootstarterreactive.error.exception.InvalidHexValueException;
import software.crldev.elrondspringbootstarterreactive.error.exception.WrongNetworkAddressException;
import software.crldev.elrondspringbootstarterreactive.util.BitsConverter;
import software.crldev.elrondspringbootstarterreactive.util.HexValidator;

public class Address {
    private final String hexValue;

    private Address(String hexValue) {
        this.hexValue = hexValue;
    }

    public static Address fromHex(String hexValue) {
        if (!HexValidator.isHexValid(hexValue, 64)) {
            throw new InvalidHexValueException(hexValue);
        }
        return new Address(hexValue);
    }

    public static Address fromBech32(String bech32Value) {
        Bech32.Bech32Data bech32Data;
        try {
            bech32Data = Bech32.decode((String)bech32Value);
        }
        catch (Exception e) {
            throw new CannotDecodeBech32AddressException();
        }
        if (!bech32Data.hrp.equals("erd")) {
            throw new WrongNetworkAddressException("erd");
        }
        byte[] decodedBytes = BitsConverter.convertBits(bech32Data.data, 5, 8, false);
        return new Address(new String(Hex.encode((byte[])decodedBytes)));
    }

    public String getHex() {
        return this.hexValue;
    }

    public byte[] getPublicKey() {
        return Hex.decode((String)this.hexValue);
    }

    public String getBech32() {
        String bech32Value = Bech32.encode((String)"erd", (byte[])BitsConverter.convertBits(this.getPublicKey(), 8, 5, true));
        if (bech32Value.length() != 62) {
            throw new CannotDecodeBech32AddressException();
        }
        return bech32Value;
    }

    public static Address zero() {
        return new Address("0000000000000000000000000000000000000000000000000000000000000000");
    }

    public boolean isZero() {
        return this.hexValue.equals("0000000000000000000000000000000000000000000000000000000000000000");
    }
}

