/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.interactor.transaction;

import lombok.Generated;
import lombok.NonNull;
import software.crldev.elrondspringbootstarterreactive.domain.account.Address;
import software.crldev.elrondspringbootstarterreactive.domain.common.Balance;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.GasLimit;
import software.crldev.elrondspringbootstarterreactive.domain.transaction.PayloadData;

public final class TransactionRequest {
    @NonNull
    private final Address receiverAddress;
    @NonNull
    private final Balance value;
    @NonNull
    private final PayloadData data;
    private final GasLimit gasLimit;

    @Generated
    TransactionRequest(@NonNull Address receiverAddress, @NonNull Balance value, @NonNull PayloadData data, GasLimit gasLimit) {
        if (receiverAddress == null) {
            throw new NullPointerException("receiverAddress is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.receiverAddress = receiverAddress;
        this.value = value;
        this.data = data;
        this.gasLimit = gasLimit;
    }

    @Generated
    public static TransactionRequestBuilder builder() {
        return new TransactionRequestBuilder();
    }

    @NonNull
    @Generated
    public Address getReceiverAddress() {
        return this.receiverAddress;
    }

    @NonNull
    @Generated
    public Balance getValue() {
        return this.value;
    }

    @NonNull
    @Generated
    public PayloadData getData() {
        return this.data;
    }

    @Generated
    public GasLimit getGasLimit() {
        return this.gasLimit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionRequest)) {
            return false;
        }
        TransactionRequest other = (TransactionRequest)o;
        Address this$receiverAddress = this.getReceiverAddress();
        Address other$receiverAddress = other.getReceiverAddress();
        if (this$receiverAddress == null ? other$receiverAddress != null : !this$receiverAddress.equals(other$receiverAddress)) {
            return false;
        }
        Balance this$value = this.getValue();
        Balance other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        PayloadData this$data = this.getData();
        PayloadData other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        GasLimit this$gasLimit = this.getGasLimit();
        GasLimit other$gasLimit = other.getGasLimit();
        return !(this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Address $receiverAddress = this.getReceiverAddress();
        result = result * 59 + ($receiverAddress == null ? 43 : $receiverAddress.hashCode());
        Balance $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        PayloadData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        GasLimit $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TransactionRequest(receiverAddress=" + this.getReceiverAddress() + ", value=" + this.getValue() + ", data=" + this.getData() + ", gasLimit=" + this.getGasLimit() + ")";
    }

    @Generated
    public static class TransactionRequestBuilder {
        @Generated
        private Address receiverAddress;
        @Generated
        private Balance value;
        @Generated
        private PayloadData data;
        @Generated
        private GasLimit gasLimit;

        @Generated
        TransactionRequestBuilder() {
        }

        @Generated
        public TransactionRequestBuilder receiverAddress(@NonNull Address receiverAddress) {
            if (receiverAddress == null) {
                throw new NullPointerException("receiverAddress is marked non-null but is null");
            }
            this.receiverAddress = receiverAddress;
            return this;
        }

        @Generated
        public TransactionRequestBuilder value(@NonNull Balance value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            this.value = value;
            return this;
        }

        @Generated
        public TransactionRequestBuilder data(@NonNull PayloadData data) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            this.data = data;
            return this;
        }

        @Generated
        public TransactionRequestBuilder gasLimit(GasLimit gasLimit) {
            this.gasLimit = gasLimit;
            return this;
        }

        @Generated
        public TransactionRequest build() {
            return new TransactionRequest(this.receiverAddress, this.value, this.data, this.gasLimit);
        }

        @Generated
        public String toString() {
            return "TransactionRequest.TransactionRequestBuilder(receiverAddress=" + this.receiverAddress + ", value=" + this.value + ", data=" + this.data + ", gasLimit=" + this.gasLimit + ")";
        }
    }
}

