/*
 * Decompiled with CFR 0.152.
 */
package software.crldev.elrondspringbootstarterreactive.interactor.network;

import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import software.crldev.elrondspringbootstarterreactive.api.ApiResourceURI;
import software.crldev.elrondspringbootstarterreactive.api.model.NetworkConfig;
import software.crldev.elrondspringbootstarterreactive.api.model.NodeHeartbeatStatus;
import software.crldev.elrondspringbootstarterreactive.api.model.ShardStatus;
import software.crldev.elrondspringbootstarterreactive.client.ErdProxyClient;
import software.crldev.elrondspringbootstarterreactive.interactor.WrappedResponses;
import software.crldev.elrondspringbootstarterreactive.interactor.network.ErdNetworkInteractor;

public class ErdNetworkInteractorImpl
implements ErdNetworkInteractor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ErdNetworkInteractorImpl.class);
    private final ErdProxyClient client;

    @Override
    public Mono<NetworkConfig> getNetworkConfig() {
        return this.client.get(ApiResourceURI.NETWORK_CONFIG.getURI(), WrappedResponses.GetNetworkConfigResponse.class).map(WrappedResponses.GetNetworkConfigResponse::getNetworkConfig);
    }

    @Override
    public Mono<ShardStatus> getShardStatus(String shardId) {
        return this.client.get(String.format(ApiResourceURI.SHARD_STATUS.getURI(), shardId), WrappedResponses.GetShardStatusResponse.class).map(WrappedResponses.GetShardStatusResponse::getShardStatus);
    }

    @Override
    public Mono<List<NodeHeartbeatStatus>> getNodeHeartbeatStatus() {
        return this.client.get(ApiResourceURI.NODE_HEARTBEAT_STATUS.getURI(), WrappedResponses.GetNodeHeartbeatStatusResponse.class).map(WrappedResponses.GetNodeHeartbeatStatusResponse::getHeartbeatstatus);
    }

    @Generated
    public ErdNetworkInteractorImpl(ErdProxyClient client) {
        this.client = client;
    }
}

